/*
 * Decompiled with CFR 0.152.
 */
package com.nicekun.uczananimation;

import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Paint;
import android.graphics.Typeface;
import android.text.TextPaint;
import com.nicekun.uczananimation.UCZanSpriteManager;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class UCZanCountIndicator {
    private final TextPaint mCountPaint;
    private final TextPaint mEncouragePaint;
    private final TextPaint mSmallEncouragePaint;
    private HashMap<String, Integer> mPointCount = new HashMap();
    private HashMap<String, Long> mPonitLastClick = new HashMap();
    private long drawCount;
    private static final int GT_IGNORECOUNT = 10;

    public UCZanCountIndicator() {
        this.mCountPaint = new TextPaint();
        this.mCountPaint.setTextSize(80.0f);
        this.mCountPaint.setAntiAlias(true);
        this.mCountPaint.setStyle(Paint.Style.FILL);
        this.mCountPaint.setColor(Color.parseColor((String)"#F9534E"));
        this.mCountPaint.setShadowLayer(6.0f, 0.0f, 0.0f, -16777216);
        this.mSmallEncouragePaint = new TextPaint();
        this.mSmallEncouragePaint.setTextSize(70.0f);
        this.mSmallEncouragePaint.setAntiAlias(true);
        this.mSmallEncouragePaint.setStyle(Paint.Style.FILL);
        this.mSmallEncouragePaint.setColor(Color.parseColor((String)"#FCD84A"));
        this.mSmallEncouragePaint.setShadowLayer(4.0f, 0.0f, 0.0f, -16777216);
        this.mEncouragePaint = new TextPaint();
        this.mEncouragePaint.setTextSize(95.0f);
        this.mEncouragePaint.setAntiAlias(true);
        this.mEncouragePaint.setStyle(Paint.Style.FILL);
        this.mEncouragePaint.setColor(Color.parseColor((String)"#FCD84A"));
        this.mEncouragePaint.setShadowLayer(6.0f, 0.0f, 0.0f, -16777216);
    }

    public void trigger(int pressX, int pressY) {
        Long lastCount = this.mPonitLastClick.get(pressX + "-" + pressY);
        if (lastCount == null) {
            this.mPointCount.put(pressX + "-" + pressY, 1);
            this.mPonitLastClick.put(pressX + "-" + pressY, this.drawCount);
            return;
        }
        int delta = this.drawCount < lastCount ? (int)(Long.MAX_VALUE - lastCount + this.drawCount) : (int)(this.drawCount - lastCount);
        Integer nowPointCount = this.mPointCount.get(pressX + "-" + pressY);
        if (delta < 10 && nowPointCount != null) {
            nowPointCount = nowPointCount + 1;
            this.mPointCount.put(pressX + "-" + pressY, nowPointCount);
        } else {
            this.mPointCount.put(pressX + "-" + pressY, 1);
        }
        this.mPonitLastClick.put(pressX + "-" + pressY, this.drawCount);
    }

    public void draw(Canvas canvas) {
        ++this.drawCount;
        if (this.drawCount == Long.MAX_VALUE) {
            this.drawCount = 0L;
        }
        Set<Map.Entry<String, Long>> entries = this.mPonitLastClick.entrySet();
        Iterator<Map.Entry<String, Long>> iterator = entries.iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, Long> next = iterator.next();
            Long lastClick = next.getValue();
            int delta = this.drawCount < lastClick ? (int)(Long.MAX_VALUE - lastClick + this.drawCount) : (int)(this.drawCount - lastClick);
            if (delta > 10) {
                iterator.remove();
                continue;
            }
            this.drawText(canvas, next.getKey());
        }
    }

    private void drawText(Canvas canvas, String pointKey) {
        String[] split = pointKey.split("-");
        int pressX = Integer.valueOf(split[0]);
        int pressY = Integer.valueOf(split[1]);
        String countExpr = "" + this.mPointCount.get(pointKey);
        float countExprWidth = this.mCountPaint.measureText(countExpr);
        EggType desc = this.getCountTextDesc(this.mPointCount.get(pointKey));
        float descWidth = this.mCountPaint.measureText(desc.getDesc());
        canvas.save();
        int width = canvas.getWidth();
        int startX = (int)((float)pressX - (descWidth + countExprWidth + 16.0f) / 2.0f);
        int endX = (int)((float)pressX + (descWidth + countExprWidth + 16.0f) / 2.0f);
        if (startX < 20) {
            canvas.translate((float)(startX + 20), 0.0f);
        } else if (endX + 20 > width) {
            canvas.translate((float)(width - endX - 20), 0.0f);
        }
        canvas.drawText(countExpr, (float)startX, (float)(pressY - 100), (Paint)this.mCountPaint);
        canvas.drawText(desc.getDesc(), (float)startX + countExprWidth + 16.0f, (float)(pressY - 100), (Paint)(desc.mGrade < 3 ? this.mSmallEncouragePaint : this.mEncouragePaint));
        canvas.restore();
    }

    private EggType getCountTextDesc(int count) {
        if (count <= 1) {
            return EggType.NORMAL_START;
        }
        if (count < 30) {
            return EggType.NORMAL;
        }
        if (count % 30 < 6) {
            if (count % 90 < 6) {
                return EggType.UNBELIEVABLE;
            }
            if (count % 60 < 6) {
                return EggType.NICE;
            }
            return EggType.GOOD;
        }
        return EggType.NORMAL;
    }

    public void setTypeface(Typeface typeface) {
        if (this.mCountPaint != null) {
            this.mCountPaint.setTypeface(typeface);
        }
        if (this.mEncouragePaint != null) {
            this.mEncouragePaint.setTypeface(typeface);
        }
        if (this.mSmallEncouragePaint != null) {
            this.mSmallEncouragePaint.setTypeface(typeface);
        }
    }

    public int getSpriteNumber(int startX, int startY) {
        Integer count = this.mPointCount.get(startX + "-" + startY);
        if (count == null) {
            return (int)(3.0 * Math.random() + 1.0);
        }
        EggType desc = this.getCountTextDesc(count);
        int baseNumber = (int)((double)(desc.mGrade * 3) * Math.random() + 1.0);
        if (desc.getGrade() > 2 && baseNumber < 6) {
            baseNumber += 6;
        }
        return baseNumber;
    }

    public UCZanSpriteManager.SpriteType getSpriteType(int startX, int startY) {
        Integer count = this.mPointCount.get(startX + "-" + startY);
        if (count == null) {
            return UCZanSpriteManager.SpriteType.NORMAL;
        }
        EggType desc = this.getCountTextDesc(count);
        return desc.getGrade() <= 2 ? UCZanSpriteManager.SpriteType.NORMAL : UCZanSpriteManager.SpriteType.SURPRISE;
    }

    public static enum EggType {
        NORMAL_START(1, "\u70b9\u8d5e"),
        NORMAL(2, "\u8fde\u51fb"),
        GOOD(3, "\u597d\u817b\u5bb3!!!"),
        NICE(4, "\u5d07\u62dc\u4f60!!!!"),
        UNBELIEVABLE(4, "\u624b\u901f\u60ca\u4eba!!!!!");

        private int mGrade;
        private String mDesc;

        private EggType(int grade, String desc) {
            this.mGrade = grade;
            this.mDesc = desc;
        }

        public int getGrade() {
            return this.mGrade;
        }

        public String getDesc() {
            return this.mDesc;
        }
    }
}

