/*
 * Decompiled with CFR 0.152.
 */
package com.nicekun.uczananimation;

import android.content.Context;
import android.content.res.AssetManager;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.util.Log;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;

public class UCZanBitmapFactory {
    private static String[] allowPictureSuffixs = new String[]{".png", ".jpg"};

    public static Bitmap from(Context context, int resId) {
        return BitmapFactory.decodeResource((Resources)context.getResources(), (int)resId);
    }

    public static Map<String, Bitmap> fromAssets(Context context, String assetsDir) {
        HashMap<String, Bitmap> result = new HashMap<String, Bitmap>();
        try {
            AssetManager assets = context.getAssets();
            String[] list = assets.list(assetsDir);
            if (list != null && list.length > 0) {
                HashSet<String> pics = new HashSet<String>();
                for (String file : list) {
                    String[] fileSplit = UCZanBitmapFactory.spliteFileNameSuffix(file);
                    if (fileSplit == null || !UCZanBitmapFactory.checkFileNameSuffixCorrect(fileSplit[1])) continue;
                    pics.add(fileSplit[0]);
                }
                block5: for (String picName : pics) {
                    for (String suffix : allowPictureSuffixs) {
                        try {
                            InputStream stream = assets.open(assetsDir + "/" + picName + suffix);
                            Bitmap bitmap = BitmapFactory.decodeStream((InputStream)stream);
                            result.put(picName, bitmap);
                            continue block5;
                        }
                        catch (IOException iOException) {
                        }
                    }
                }
            }
        }
        catch (IOException e) {
            Log.e((String)"UCZanAnimation", (String)("UCZanBitmapFactory - fromAssets ERROR : " + e.getMessage()));
        }
        return result;
    }

    private static boolean checkFileNameSuffixCorrect(String fsuffix) {
        if (fsuffix == null) {
            return false;
        }
        for (String suffix : allowPictureSuffixs) {
            if (!fsuffix.equals(suffix)) continue;
            return true;
        }
        return false;
    }

    private static String[] spliteFileNameSuffix(String fileName) {
        int pos;
        if (fileName != null && fileName.length() > 2 && (pos = fileName.lastIndexOf(".")) != -1) {
            String picName = fileName.substring(0, pos);
            String picSuffix = fileName.substring(pos, fileName.length());
            return new String[]{picName, picSuffix};
        }
        return null;
    }

    public static Map<String, Bitmap> fromAssetsZipFile(Context context, String zipFileName) {
        return null;
    }
}

