/*
 * Decompiled with CFR 0.152.
 */
package com.nicekun.uczananimation;

import android.content.Context;
import android.graphics.Bitmap;
import com.nicekun.uczananimation.UCZanBitmapFactory;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class UCZanAnimationResource {
    private List<Bitmap> normalList = new ArrayList<Bitmap>();
    private List<Bitmap> supriseList = new ArrayList<Bitmap>();

    private UCZanAnimationResource(UCZanAnimationResourceBuilder builder) {
        for (Map.Entry<String, Bitmap> entry : builder.res.entrySet()) {
            if (builder.suprsizeNameList.contains(entry.getKey())) {
                this.supriseList.add(entry.getValue());
                continue;
            }
            this.normalList.add(entry.getValue());
        }
    }

    public Bitmap getRandomBitmap() {
        return this.getRandomBitmap(false);
    }

    public Bitmap getRandomBitmap(boolean surprise) {
        Bitmap bitmap = null;
        if (surprise) {
            if (this.supriseList.size() > 0) {
                bitmap = this.supriseList.get((int)(Math.random() * (double)this.supriseList.size()));
            }
        } else if (this.normalList.size() > 0) {
            bitmap = this.normalList.get((int)(Math.random() * (double)this.normalList.size()));
        }
        return bitmap;
    }

    public Bitmap getBitmapByResId() {
        return null;
    }

    public Bitmap getBitmapByName() {
        return null;
    }

    public static class UCZanAnimationResourceBuilder {
        private Context mContext;
        HashMap<String, Bitmap> res = new HashMap();
        List<String> suprsizeNameList = new ArrayList<String>();

        public UCZanAnimationResourceBuilder(Context context) {
            this.mContext = context;
        }

        public UCZanAnimationResource build() {
            return new UCZanAnimationResource(this);
        }

        public UCZanAnimationResourceBuilder appendResource(int resId) {
            Bitmap bitmap = UCZanBitmapFactory.from(this.mContext, resId);
            this.res.put("res-" + this.res, bitmap);
            return this;
        }

        public UCZanAnimationResourceBuilder appendAssetResource(String assetDir) {
            Map<String, Bitmap> bitmaps = UCZanBitmapFactory.fromAssets(this.mContext, assetDir);
            if (bitmaps != null) {
                for (Map.Entry<String, Bitmap> entry : bitmaps.entrySet()) {
                    this.res.put("assets-" + entry.getKey(), entry.getValue());
                }
            }
            return this;
        }

        public UCZanAnimationResourceBuilder setSupriseFileNameOfAssets(String[] fileName) {
            for (String f : fileName) {
                this.suprsizeNameList.add("assets-" + f);
            }
            return this;
        }

        public UCZanAnimationResourceBuilder setSupriseFileNameOfRes(String[] fileName) {
            for (String f : fileName) {
                this.suprsizeNameList.add("res-" + f);
            }
            return this;
        }

        public UCZanAnimationResourceBuilder appendAssetZipResource(String zipFileName) {
            Map<String, Bitmap> bitmaps = UCZanBitmapFactory.fromAssetsZipFile(this.mContext, zipFileName);
            if (bitmaps != null) {
                this.res.putAll(bitmaps);
            }
            return this;
        }

        public UCZanAnimationResourceBuilder appendResource(Bitmap bitmap, String tag) {
            this.res.put(tag, bitmap);
            return this;
        }

        public UCZanAnimationResourceBuilder appendResources(Map<String, Bitmap> bitmaps) {
            if (bitmaps != null) {
                this.res.putAll(bitmaps);
            }
            return this;
        }
    }
}

