/*
 * Decompiled with CFR 0.152.
 */
package com.nicekun.uczananimation;

import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.PorterDuff;
import android.graphics.Rect;
import android.graphics.Typeface;
import android.util.Log;
import android.view.SurfaceHolder;
import com.nicekun.uczananimation.UCZanAnimationBaseFunction;
import com.nicekun.uczananimation.UCZanCountIndicator;
import com.nicekun.uczananimation.UCZanSprite;
import com.nicekun.uczananimation.UCZanSpriteManager;
import com.nicekun.uczananimation.UCZanUtils;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;

public class UCZanAnimationDirector
implements Runnable {
    private SurfaceHolder mSurfaceHolder;
    private final Paint mPaint;
    private CopyOnWriteArrayList<UCZanSprite> mList = new CopyOnWriteArrayList();
    private UCZanSpriteManager mUcZanSpriteManager;
    private static final int THREAD_CANCEL = 1;
    private static final int THREAD_NORMAL = 4096;
    private int mThreadStatus;
    private final UCZanCountIndicator mZanCountIndicator;
    private Callback mCallback;

    public UCZanAnimationDirector(SurfaceHolder holder) {
        this.mSurfaceHolder = holder;
        this.mPaint = new Paint();
        this.mZanCountIndicator = new UCZanCountIndicator();
    }

    public void setSpriteManager(UCZanSpriteManager spriteManager) {
        this.mUcZanSpriteManager = spriteManager;
    }

    public void generateZan(int startX, int startY) {
        this.mZanCountIndicator.trigger(startX, startY);
        List<UCZanSprite> sprites = this.mUcZanSpriteManager.obtain(this.mZanCountIndicator.getSpriteNumber(startX, startY), this.mZanCountIndicator.getSpriteType(startX, startY));
        for (UCZanSprite randomSprite : sprites) {
            randomSprite.setPostion(startX, startY);
            randomSprite.setGravity(UCZanSprite.Gravity.CENTER);
            randomSprite.setFunction(new UCZanAnimationBaseFunction((float)(-20.0 * Math.random()), (float)(-10.0 * Math.random() + 2.0)));
            this.addSprite(randomSprite);
        }
    }

    private void addSprite(UCZanSprite sprite) {
        if (sprite != null) {
            this.mList.add(sprite);
            if (this.mCallback != null) {
                this.mCallback.onSpriteCountChanged(this.mList.size());
            }
        }
    }

    public void onCreate() {
        this.mThreadStatus = 4096;
        new Thread(this).start();
    }

    public void onDestroy() {
        this.mThreadStatus = 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        while (this.mThreadStatus != 1) {
            Canvas canvas = this.mSurfaceHolder.lockCanvas();
            try {
                if (canvas != null) {
                    canvas.drawColor(0, PorterDuff.Mode.CLEAR);
                    for (UCZanSprite sprite : this.mList) {
                        Rect rect = sprite.getRect();
                        Rect clipBounds = canvas.getClipBounds();
                        if (!UCZanUtils.outOf(clipBounds, rect) && sprite.getAlpha() > 0) {
                            sprite.draw(canvas, this.mPaint);
                            continue;
                        }
                        this.mList.remove(sprite);
                        if (this.mCallback == null) continue;
                        this.mCallback.onSpriteCountChanged(this.mList.size());
                    }
                    this.mZanCountIndicator.draw(canvas);
                }
                Thread.sleep(80L);
            }
            catch (Exception e) {
                Log.e((String)"UCZanAnimation", (String)("UCZanAnimationDirector - run: " + e.toString()));
            }
            finally {
                if (canvas == null) continue;
                this.mSurfaceHolder.unlockCanvasAndPost(canvas);
            }
        }
    }

    public void addCallback(Callback callback) {
        this.mCallback = callback;
    }

    public void setIndicatorTypeface(Typeface typeface) {
        if (this.mZanCountIndicator != null) {
            this.mZanCountIndicator.setTypeface(typeface);
        }
    }

    public static interface Callback {
        public void onSpriteCountChanged(int var1);
    }
}

