/*
 * Decompiled with CFR 0.152.
 */
package com.nfx.android.rangebarpreference;

import android.app.Dialog;
import android.content.Context;
import android.content.res.TypedArray;
import android.support.v7.app.AlertDialog;
import android.util.Log;
import android.util.TypedValue;
import android.view.LayoutInflater;
import android.view.View;
import android.widget.Button;
import android.widget.EditText;
import android.widget.LinearLayout;
import android.widget.TextView;
import com.nfx.android.rangebarpreference.CustomValueDialogListener;
import com.nfx.android.rangebarpreference.R;
import com.nfx.android.rangebarpreference.RangeBarHelper;

class CustomValueDialog {
    private final String TAG = this.getClass().getSimpleName();
    private final float minValue;
    private final float maxValue;
    private final float currentValue;
    private Dialog dialog;
    private EditText customValueView;
    private CustomValueDialogListener persistValueListener;

    CustomValueDialog(Context context, int theme, float minValue, float maxValue, float currentValue) {
        this.minValue = minValue;
        this.maxValue = maxValue;
        this.currentValue = currentValue;
        this.init(new AlertDialog.Builder(context, theme));
    }

    private void init(AlertDialog.Builder dialogBuilder) {
        View dialogView = LayoutInflater.from((Context)dialogBuilder.getContext()).inflate(R.layout.value_selector_dialog, null);
        this.dialog = dialogBuilder.setView(dialogView).create();
        TextView minValueView = (TextView)dialogView.findViewById(R.id.minValue);
        TextView maxValueView = (TextView)dialogView.findViewById(R.id.maxValue);
        this.customValueView = (EditText)dialogView.findViewById(R.id.customValue);
        minValueView.setText((CharSequence)RangeBarHelper.formatFloatToString(this.minValue));
        maxValueView.setText((CharSequence)RangeBarHelper.formatFloatToString(this.maxValue));
        this.customValueView.setHint((CharSequence)RangeBarHelper.formatFloatToString(this.currentValue));
        LinearLayout colorView = (LinearLayout)dialogView.findViewById(R.id.dialog_color_area);
        colorView.setBackgroundColor(this.fetchAccentColor(dialogBuilder.getContext()));
        Button applyButton = (Button)dialogView.findViewById(R.id.btn_apply);
        Button cancelButton = (Button)dialogView.findViewById(R.id.btn_cancel);
        applyButton.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                CustomValueDialog.this.tryApply();
            }
        });
        cancelButton.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                CustomValueDialog.this.dialog.dismiss();
            }
        });
    }

    private int fetchAccentColor(Context context) {
        TypedValue typedValue = new TypedValue();
        TypedArray a = context.obtainStyledAttributes(typedValue.data, new int[]{R.attr.colorAccent});
        int color = a.getColor(0, 0);
        a.recycle();
        return color;
    }

    CustomValueDialog setOnChangeListener(CustomValueDialogListener listener) {
        this.persistValueListener = listener;
        return this;
    }

    void show() {
        this.dialog.show();
    }

    private void tryApply() {
        float value;
        try {
            value = Float.parseFloat(this.customValueView.getText().toString());
            if (value > this.maxValue) {
                Log.e((String)this.TAG, (String)("wrong input( > than required): " + this.customValueView.getText().toString()));
                this.notifyWrongInput();
                return;
            }
            if (value < this.minValue) {
                Log.e((String)this.TAG, (String)("wrong input( < then required): " + this.customValueView.getText().toString()));
                this.notifyWrongInput();
                return;
            }
        }
        catch (Exception e) {
            Log.e((String)this.TAG, (String)("wrong input(non-integer): " + this.customValueView.getText().toString()));
            this.notifyWrongInput();
            return;
        }
        if (this.persistValueListener != null) {
            this.persistValueListener.onChangeValue(value);
            this.dialog.dismiss();
        }
    }

    private void notifyWrongInput() {
        this.customValueView.setText((CharSequence)"");
        this.customValueView.setHint((CharSequence)"Wrong Input!");
    }
}

