/*
 * Decompiled with CFR 0.152.
 */
package com.nfx.android.preferencehelper.preferences;

import android.content.SharedPreferences;
import android.support.annotation.NonNull;

public class IntegerPreference {
    private final SharedPreferences preferences;
    private final String key;
    private final int defaultValue;

    public IntegerPreference(@NonNull SharedPreferences preferences, @NonNull String key, int defaultValue) {
        this.preferences = preferences;
        this.key = key;
        this.defaultValue = defaultValue;
    }

    public int get() {
        return this.preferences.getInt(this.key, this.defaultValue);
    }

    public boolean isSet() {
        return this.preferences.contains(this.key);
    }

    public void set(int value) {
        this.preferences.edit().putInt(this.key, value).apply();
    }

    public void delete() {
        this.preferences.edit().remove(this.key).apply();
    }
}

