/*
 * Decompiled with CFR 0.152.
 */
package com.neyogiry.android.barcodescanner.objectdetection;

import android.graphics.Bitmap;
import android.graphics.Rect;
import android.util.Log;
import com.google.firebase.ml.vision.common.FirebaseVisionImage;
import com.google.firebase.ml.vision.objects.FirebaseVisionObject;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.OutputStream;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0012\n\u0002\b\f\u0018\u0000 \u001b2\u00020\u0001:\u0001\u001bB\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0006\u0010\u001a\u001a\u00020\nR\u0010\u0010\t\u001a\u0004\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u000b\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u000f\u001a\u0004\u0018\u00010\u00108F\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012R\u0010\u0010\u0013\u001a\u0004\u0018\u00010\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0015\u0010\u0014\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\n\n\u0002\u0010\u0017\u001a\u0004\b\u0015\u0010\u0016R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lcom/neyogiry/android/barcodescanner/objectdetection/DetectedObject;", "", "visionObject", "Lcom/google/firebase/ml/vision/objects/FirebaseVisionObject;", "objectIndex", "", "image", "Lcom/google/firebase/ml/vision/common/FirebaseVisionImage;", "(Lcom/google/firebase/ml/vision/objects/FirebaseVisionObject;ILcom/google/firebase/ml/vision/common/FirebaseVisionImage;)V", "bitmap", "Landroid/graphics/Bitmap;", "boundingBox", "Landroid/graphics/Rect;", "getBoundingBox", "()Landroid/graphics/Rect;", "imageData", "", "getImageData", "()[B", "jpegBytes", "objectId", "getObjectId", "()Ljava/lang/Integer;", "Ljava/lang/Integer;", "getObjectIndex", "()I", "getBitmap", "Companion", "barcodescanner_release"})
public final class DetectedObject {
    private Bitmap bitmap;
    private byte[] jpegBytes;
    @Nullable
    private final Integer objectId;
    @NotNull
    private final Rect boundingBox;
    private final FirebaseVisionObject visionObject;
    private final int objectIndex;
    private final FirebaseVisionImage image;
    private static final String TAG = "DetectedObject";
    private static final int MAX_IMAGE_WIDTH = 640;
    public static final Companion Companion = new Companion(null);

    @Nullable
    public final Integer getObjectId() {
        return this.objectId;
    }

    @NotNull
    public final Rect getBoundingBox() {
        return this.boundingBox;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public final synchronized byte[] getImageData() {
        if (this.jpegBytes == null) {
            try {
                Closeable closeable = new ByteArrayOutputStream();
                boolean bl = false;
                Throwable throwable = null;
                try {
                    ByteArrayOutputStream stream = (ByteArrayOutputStream)closeable;
                    boolean bl2 = false;
                    this.getBitmap().compress(Bitmap.CompressFormat.JPEG, 100, (OutputStream)stream);
                    this.jpegBytes = stream.toByteArray();
                    Unit unit = Unit.INSTANCE;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                }
            }
            catch (IOException e) {
                Log.e((String)TAG, (String)"Error getting object image data!");
            }
        }
        return this.jpegBytes;
    }

    @NotNull
    public final synchronized Bitmap getBitmap() {
        Bitmap bitmap = this.bitmap;
        if (bitmap == null) {
            Bitmap createdBitmap;
            DetectedObject detectedObject = this;
            boolean bl = false;
            boolean bl2 = false;
            DetectedObject it = detectedObject;
            boolean bl3 = false;
            Rect rect = this.visionObject.getBoundingBox();
            Intrinsics.checkExpressionValueIsNotNull((Object)rect, (String)"visionObject.boundingBox");
            Rect boundingBox = rect;
            Bitmap bitmap2 = createdBitmap = Bitmap.createBitmap((Bitmap)this.image.getBitmap(), (int)boundingBox.left, (int)boundingBox.top, (int)boundingBox.width(), (int)boundingBox.height());
            Intrinsics.checkExpressionValueIsNotNull((Object)bitmap2, (String)"createdBitmap");
            if (bitmap2.getWidth() > 640) {
                int dstHeight = (int)((float)640 / (float)createdBitmap.getWidth() * (float)createdBitmap.getHeight());
                this.bitmap = Bitmap.createScaledBitmap((Bitmap)createdBitmap, (int)640, (int)dstHeight, (boolean)false);
            }
            bitmap = createdBitmap;
        }
        return bitmap;
    }

    public final int getObjectIndex() {
        return this.objectIndex;
    }

    public DetectedObject(@NotNull FirebaseVisionObject visionObject, int objectIndex, @NotNull FirebaseVisionImage image) {
        Intrinsics.checkParameterIsNotNull((Object)visionObject, (String)"visionObject");
        Intrinsics.checkParameterIsNotNull((Object)image, (String)"image");
        this.visionObject = visionObject;
        this.objectIndex = objectIndex;
        this.image = image;
        this.objectId = this.visionObject.getTrackingId();
        Rect rect = this.visionObject.getBoundingBox();
        Intrinsics.checkExpressionValueIsNotNull((Object)rect, (String)"visionObject.boundingBox");
        this.boundingBox = rect;
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lcom/neyogiry/android/barcodescanner/objectdetection/DetectedObject$Companion;", "", "()V", "MAX_IMAGE_WIDTH", "", "TAG", "", "barcodescanner_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

