/*
 * Decompiled with CFR 0.152.
 */
package com.neyogiry.android.barcodescanner.camera;

import android.os.SystemClock;
import android.util.Log;
import androidx.annotation.GuardedBy;
import com.google.android.gms.tasks.OnFailureListener;
import com.google.android.gms.tasks.OnSuccessListener;
import com.google.android.gms.tasks.Task;
import com.google.firebase.ml.vision.common.FirebaseVisionImage;
import com.google.firebase.ml.vision.common.FirebaseVisionImageMetadata;
import com.neyogiry.android.barcodescanner.camera.FrameMetadata;
import com.neyogiry.android.barcodescanner.camera.FrameProcessor;
import com.neyogiry.android.barcodescanner.camera.GraphicOverlay;
import java.nio.ByteBuffer;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000B\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\b&\u0018\u0000 \u001c*\u0004\b\u0000\u0010\u00012\u00020\u0002:\u0001\u001cB\u0005\u00a2\u0006\u0002\u0010\u0003J\u0016\u0010\n\u001a\b\u0012\u0004\u0012\u00028\u00000\u000b2\u0006\u0010\f\u001a\u00020\rH$J\u0014\u0010\u000e\u001a\u00020\u000f2\n\u0010\u0010\u001a\u00060\u0011j\u0002`\u0012H$J%\u0010\u0013\u001a\u00020\u000f2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0014\u001a\u00028\u00002\u0006\u0010\u0015\u001a\u00020\u0016H$\u00a2\u0006\u0002\u0010\u0017J \u0010\u0018\u001a\u00020\u000f2\u0006\u0010\u0019\u001a\u00020\u00052\u0006\u0010\u001a\u001a\u00020\u00072\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\u0010\u0010\u001b\u001a\u00020\u000f2\u0006\u0010\u0015\u001a\u00020\u0016H\u0002R\u0014\u0010\u0004\u001a\u0004\u0018\u00010\u00058\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\u0004\u0018\u00010\u00078\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\u0004\u0018\u00010\u00058\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\u0004\u0018\u00010\u00078\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lcom/neyogiry/android/barcodescanner/camera/FrameProcessorBase;", "T", "Lcom/neyogiry/android/barcodescanner/camera/FrameProcessor;", "()V", "latestFrame", "Ljava/nio/ByteBuffer;", "latestFrameMetaData", "Lcom/neyogiry/android/barcodescanner/camera/FrameMetadata;", "processingFrame", "processingFrameMetaData", "detectInImage", "Lcom/google/android/gms/tasks/Task;", "image", "Lcom/google/firebase/ml/vision/common/FirebaseVisionImage;", "onFailure", "", "e", "Ljava/lang/Exception;", "Lkotlin/Exception;", "onSuccess", "results", "graphicOverlay", "Lcom/neyogiry/android/barcodescanner/camera/GraphicOverlay;", "(Lcom/google/firebase/ml/vision/common/FirebaseVisionImage;Ljava/lang/Object;Lcom/neyogiry/android/barcodescanner/camera/GraphicOverlay;)V", "process", "data", "frameMetadata", "processLatestFrame", "Companion", "barcodescanner_release"})
public abstract class FrameProcessorBase<T>
implements FrameProcessor {
    @GuardedBy(value="this")
    private ByteBuffer latestFrame;
    @GuardedBy(value="this")
    private FrameMetadata latestFrameMetaData;
    @GuardedBy(value="this")
    private ByteBuffer processingFrame;
    @GuardedBy(value="this")
    private FrameMetadata processingFrameMetaData;
    private static final String TAG = "FrameProcessorBase";
    public static final Companion Companion = new Companion(null);

    @Override
    public synchronized void process(@NotNull ByteBuffer data, @NotNull FrameMetadata frameMetadata, @NotNull GraphicOverlay graphicOverlay) {
        Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
        Intrinsics.checkParameterIsNotNull((Object)frameMetadata, (String)"frameMetadata");
        Intrinsics.checkParameterIsNotNull((Object)((Object)graphicOverlay), (String)"graphicOverlay");
        this.latestFrame = data;
        this.latestFrameMetaData = frameMetadata;
        if (this.processingFrame == null && this.processingFrameMetaData == null) {
            this.processLatestFrame(graphicOverlay);
        }
    }

    private final synchronized void processLatestFrame(GraphicOverlay graphicOverlay) {
        this.processingFrame = this.latestFrame;
        this.processingFrameMetaData = this.latestFrameMetaData;
        this.latestFrame = null;
        this.latestFrameMetaData = null;
        ByteBuffer byteBuffer = this.processingFrame;
        if (byteBuffer == null) {
            return;
        }
        ByteBuffer frame = byteBuffer;
        FrameMetadata frameMetadata = this.processingFrameMetaData;
        if (frameMetadata == null) {
            return;
        }
        FrameMetadata frameMetaData = frameMetadata;
        FirebaseVisionImageMetadata firebaseVisionImageMetadata = new FirebaseVisionImageMetadata.Builder().setFormat(17).setWidth(frameMetaData.getWidth()).setHeight(frameMetaData.getHeight()).setRotation(frameMetaData.getRotation()).build();
        Intrinsics.checkExpressionValueIsNotNull((Object)firebaseVisionImageMetadata, (String)"FirebaseVisionImageMetad\u2026ion)\n            .build()");
        FirebaseVisionImageMetadata metadata = firebaseVisionImageMetadata;
        FirebaseVisionImage firebaseVisionImage = FirebaseVisionImage.fromByteBuffer((ByteBuffer)frame, (FirebaseVisionImageMetadata)metadata);
        Intrinsics.checkExpressionValueIsNotNull((Object)firebaseVisionImage, (String)"FirebaseVisionImage.from\u2026teBuffer(frame, metadata)");
        FirebaseVisionImage image = firebaseVisionImage;
        long startMs = SystemClock.elapsedRealtime();
        this.detectInImage(image).addOnSuccessListener(new OnSuccessListener<T>(this, startMs, image, graphicOverlay){
            final /* synthetic */ FrameProcessorBase this$0;
            final /* synthetic */ long $startMs;
            final /* synthetic */ FirebaseVisionImage $image;
            final /* synthetic */ GraphicOverlay $graphicOverlay;

            public final void onSuccess(T results) {
                Log.d((String)"FrameProcessorBase", (String)("Latency is: " + (SystemClock.elapsedRealtime() - this.$startMs)));
                this.this$0.onSuccess(this.$image, results, this.$graphicOverlay);
                FrameProcessorBase.access$processLatestFrame(this.this$0, this.$graphicOverlay);
            }
            {
                this.this$0 = frameProcessorBase;
                this.$startMs = l;
                this.$image = firebaseVisionImage;
                this.$graphicOverlay = graphicOverlay;
            }
        }).addOnFailureListener(new OnFailureListener(this){
            final /* synthetic */ FrameProcessorBase this$0;

            public final void onFailure(@NotNull Exception it) {
                Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                this.this$0.onFailure(it);
            }
            {
                this.this$0 = frameProcessorBase;
            }
        });
    }

    @NotNull
    protected abstract Task<T> detectInImage(@NotNull FirebaseVisionImage var1);

    protected abstract void onSuccess(@NotNull FirebaseVisionImage var1, T var2, @NotNull GraphicOverlay var3);

    protected abstract void onFailure(@NotNull Exception var1);

    public static final /* synthetic */ void access$processLatestFrame(FrameProcessorBase $this, GraphicOverlay graphicOverlay) {
        $this.processLatestFrame(graphicOverlay);
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/neyogiry/android/barcodescanner/camera/FrameProcessorBase$Companion;", "", "()V", "TAG", "", "barcodescanner_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

