/*
 * Decompiled with CFR 0.152.
 */
package com.neyogiry.android.barcodescanner.barcodedetection;

import android.animation.ValueAnimator;
import android.graphics.Rect;
import android.graphics.RectF;
import android.util.Log;
import androidx.annotation.MainThread;
import com.google.android.gms.tasks.Task;
import com.google.firebase.ml.vision.FirebaseVision;
import com.google.firebase.ml.vision.barcode.FirebaseVisionBarcode;
import com.google.firebase.ml.vision.barcode.FirebaseVisionBarcodeDetector;
import com.google.firebase.ml.vision.common.FirebaseVisionImage;
import com.neyogiry.android.barcodescanner.Utils;
import com.neyogiry.android.barcodescanner.barcodedetection.BarcodeConfirmingGraphic;
import com.neyogiry.android.barcodescanner.barcodedetection.BarcodeLoadingGraphic;
import com.neyogiry.android.barcodescanner.barcodedetection.BarcodeReticleGraphic;
import com.neyogiry.android.barcodescanner.camera.CameraReticleAnimator;
import com.neyogiry.android.barcodescanner.camera.FrameProcessorBase;
import com.neyogiry.android.barcodescanner.camera.GraphicOverlay;
import com.neyogiry.android.barcodescanner.camera.WorkflowModel;
import java.io.IOException;
import java.util.List;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u0000 \u001c2\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\u00020\u0001:\u0001\u001cB\u0015\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0018\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u000f\u001a\u00020\u0003H\u0002J\u001c\u0010\u0010\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0014J\u0014\u0010\u0014\u001a\u00020\u00152\n\u0010\u0016\u001a\u00060\u0017j\u0002`\u0018H\u0014J&\u0010\u0019\u001a\u00020\u00152\u0006\u0010\u0012\u001a\u00020\u00132\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00030\u00022\u0006\u0010\u0004\u001a\u00020\u0005H\u0015J\b\u0010\u001b\u001a\u00020\u0015H\u0016R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lcom/neyogiry/android/barcodescanner/barcodedetection/BarcodeProcessor;", "Lcom/neyogiry/android/barcodescanner/camera/FrameProcessorBase;", "", "Lcom/google/firebase/ml/vision/barcode/FirebaseVisionBarcode;", "graphicOverlay", "Lcom/neyogiry/android/barcodescanner/camera/GraphicOverlay;", "workflowModel", "Lcom/neyogiry/android/barcodescanner/camera/WorkflowModel;", "(Lcom/neyogiry/android/barcodescanner/camera/GraphicOverlay;Lcom/neyogiry/android/barcodescanner/camera/WorkflowModel;)V", "cameraReticleAnimator", "Lcom/neyogiry/android/barcodescanner/camera/CameraReticleAnimator;", "detector", "Lcom/google/firebase/ml/vision/barcode/FirebaseVisionBarcodeDetector;", "createLoadingAnimator", "Landroid/animation/ValueAnimator;", "barcode", "detectInImage", "Lcom/google/android/gms/tasks/Task;", "image", "Lcom/google/firebase/ml/vision/common/FirebaseVisionImage;", "onFailure", "", "e", "Ljava/lang/Exception;", "Lkotlin/Exception;", "onSuccess", "results", "stop", "Companion", "barcodescanner_release"})
public final class BarcodeProcessor
extends FrameProcessorBase<List<? extends FirebaseVisionBarcode>> {
    private final FirebaseVisionBarcodeDetector detector;
    private final CameraReticleAnimator cameraReticleAnimator;
    private final WorkflowModel workflowModel;
    private static final String TAG = "BarcodeProcessor";
    public static final Companion Companion = new Companion(null);

    @Override
    @NotNull
    protected Task<List<FirebaseVisionBarcode>> detectInImage(@NotNull FirebaseVisionImage image) {
        Intrinsics.checkParameterIsNotNull((Object)image, (String)"image");
        Task task = this.detector.detectInImage(image);
        Intrinsics.checkExpressionValueIsNotNull((Object)task, (String)"detector.detectInImage(image)");
        return task;
    }

    @Override
    @MainThread
    protected void onSuccess(@NotNull FirebaseVisionImage image, @NotNull List<? extends FirebaseVisionBarcode> results, @NotNull GraphicOverlay graphicOverlay) {
        Object v1;
        block8: {
            Intrinsics.checkParameterIsNotNull((Object)image, (String)"image");
            Intrinsics.checkParameterIsNotNull(results, (String)"results");
            Intrinsics.checkParameterIsNotNull((Object)((Object)graphicOverlay), (String)"graphicOverlay");
            if (!this.workflowModel.isCameraLive()) {
                return;
            }
            Log.d((String)TAG, (String)("Barcode result size: " + results.size()));
            Iterable $this$firstOrNull$iv = results;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                boolean bl;
                FirebaseVisionBarcode barcode = (FirebaseVisionBarcode)element$iv;
                boolean bl2 = false;
                if (barcode.getBoundingBox() == null) {
                    bl = false;
                } else {
                    Rect boundingBox;
                    Intrinsics.checkExpressionValueIsNotNull((Object)boundingBox, (String)"barcode.boundingBox ?: return@firstOrNull false");
                    RectF box = graphicOverlay.translateRect(boundingBox);
                    bl = box.contains((float)graphicOverlay.getWidth() / 2.0f, (float)graphicOverlay.getHeight() / 2.0f);
                }
                if (!bl) continue;
                v1 = element$iv;
                break block8;
            }
            v1 = null;
        }
        FirebaseVisionBarcode barcodeInCenter = v1;
        graphicOverlay.clear();
        if (barcodeInCenter == null) {
            this.cameraReticleAnimator.start();
            graphicOverlay.add(new BarcodeReticleGraphic(graphicOverlay, this.cameraReticleAnimator));
            this.workflowModel.setWorkflowState(WorkflowModel.WorkflowState.DETECTING);
        } else {
            this.cameraReticleAnimator.cancel();
            float sizeProgress = Utils.INSTANCE.getProgressToMeetBarcodeSizeRequirement(graphicOverlay, barcodeInCenter);
            if (sizeProgress < 1.0f) {
                graphicOverlay.add(new BarcodeConfirmingGraphic(graphicOverlay, barcodeInCenter));
                this.workflowModel.setWorkflowState(WorkflowModel.WorkflowState.CONFIRMING);
            } else {
                ValueAnimator loadingAnimator = this.createLoadingAnimator(graphicOverlay, barcodeInCenter);
                loadingAnimator.start();
                graphicOverlay.add(new BarcodeLoadingGraphic(graphicOverlay, loadingAnimator));
                this.workflowModel.setWorkflowState(WorkflowModel.WorkflowState.SEARCHING);
            }
        }
        graphicOverlay.invalidate();
    }

    private final ValueAnimator createLoadingAnimator(GraphicOverlay graphicOverlay, FirebaseVisionBarcode barcode) {
        float endProgress = 1.1f;
        ValueAnimator valueAnimator = ValueAnimator.ofFloat((float[])new float[]{0.0f, endProgress});
        boolean bl = false;
        boolean bl2 = false;
        ValueAnimator $this$apply = valueAnimator;
        boolean bl3 = false;
        $this$apply.setDuration(2000L);
        $this$apply.addUpdateListener(new ValueAnimator.AnimatorUpdateListener($this$apply, this, endProgress, graphicOverlay, barcode){
            final /* synthetic */ ValueAnimator $this_apply;
            final /* synthetic */ BarcodeProcessor this$0;
            final /* synthetic */ float $endProgress$inlined;
            final /* synthetic */ GraphicOverlay $graphicOverlay$inlined;
            final /* synthetic */ FirebaseVisionBarcode $barcode$inlined;
            {
                this.$this_apply = valueAnimator;
                this.this$0 = barcodeProcessor;
                this.$endProgress$inlined = f;
                this.$graphicOverlay$inlined = graphicOverlay;
                this.$barcode$inlined = firebaseVisionBarcode;
            }

            public final void onAnimationUpdate(ValueAnimator it) {
                Object object = this.$this_apply.getAnimatedValue();
                if (object == null) {
                    throw new TypeCastException("null cannot be cast to non-null type kotlin.Float");
                }
                if (Float.compare(((Float)object).floatValue(), this.$endProgress$inlined) >= 0) {
                    this.$graphicOverlay$inlined.clear();
                    BarcodeProcessor.access$getWorkflowModel$p(this.this$0).setWorkflowState(WorkflowModel.WorkflowState.SEARCHED);
                    BarcodeProcessor.access$getWorkflowModel$p(this.this$0).getDetectedBarcode().setValue((Object)this.$barcode$inlined);
                } else {
                    this.$graphicOverlay$inlined.invalidate();
                }
            }
        });
        ValueAnimator valueAnimator2 = valueAnimator;
        Intrinsics.checkExpressionValueIsNotNull((Object)valueAnimator2, (String)"ValueAnimator.ofFloat(0f\u2026}\n            }\n        }");
        return valueAnimator2;
    }

    @Override
    protected void onFailure(@NotNull Exception e) {
        Intrinsics.checkParameterIsNotNull((Object)e, (String)"e");
        Log.e((String)TAG, (String)"Barcode detection failed!", (Throwable)e);
    }

    @Override
    public void stop() {
        try {
            this.detector.close();
        }
        catch (IOException e) {
            Log.e((String)TAG, (String)"Failed to close barcode detector!", (Throwable)e);
        }
    }

    public BarcodeProcessor(@NotNull GraphicOverlay graphicOverlay, @NotNull WorkflowModel workflowModel) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)graphicOverlay), (String)"graphicOverlay");
        Intrinsics.checkParameterIsNotNull((Object)((Object)workflowModel), (String)"workflowModel");
        this.workflowModel = workflowModel;
        FirebaseVision firebaseVision = FirebaseVision.getInstance();
        Intrinsics.checkExpressionValueIsNotNull((Object)firebaseVision, (String)"FirebaseVision.getInstance()");
        FirebaseVisionBarcodeDetector firebaseVisionBarcodeDetector = firebaseVision.getVisionBarcodeDetector();
        Intrinsics.checkExpressionValueIsNotNull((Object)firebaseVisionBarcodeDetector, (String)"FirebaseVision.getInstance().visionBarcodeDetector");
        this.detector = firebaseVisionBarcodeDetector;
        this.cameraReticleAnimator = new CameraReticleAnimator(graphicOverlay);
    }

    public static final /* synthetic */ WorkflowModel access$getWorkflowModel$p(BarcodeProcessor $this) {
        return $this.workflowModel;
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/neyogiry/android/barcodescanner/barcodedetection/BarcodeProcessor$Companion;", "", "()V", "TAG", "", "barcodescanner_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

