/*
 * Decompiled with CFR 0.152.
 */
package nextapp.echo.app.text;

import java.util.EventListener;
import nextapp.echo.app.Alignment;
import nextapp.echo.app.Border;
import nextapp.echo.app.BorderedComponent;
import nextapp.echo.app.Color;
import nextapp.echo.app.Component;
import nextapp.echo.app.Extent;
import nextapp.echo.app.FillImage;
import nextapp.echo.app.Font;
import nextapp.echo.app.Insets;
import nextapp.echo.app.event.ActionEvent;
import nextapp.echo.app.event.ActionListener;
import nextapp.echo.app.event.DocumentEvent;
import nextapp.echo.app.event.DocumentListener;
import nextapp.echo.app.text.Document;

public abstract class TextComponent
extends BorderedComponent {
    public static final String INPUT_ACTION = "action";
    public static final String PROPERTY_ACTION_COMMAND = "actionCommand";
    public static final String PROPERTY_ALIGNMENT = "alignment";
    public static final String PROPERTY_BACKGROUND_IMAGE = "backgroundImage";
    public static final String PROPERTY_DISABLED_BACKGROUND = "disabledBackground";
    public static final String PROPERTY_DISABLED_BACKGROUND_IMAGE = "disabledBackgroundImage";
    public static final String PROPERTY_DISABLED_BORDER = "disabledBorder";
    public static final String PROPERTY_DISABLED_FONT = "disabledFont";
    public static final String PROPERTY_DISABLED_FOREGROUND = "disabledForeground";
    public static final String PROPERTY_EDITABLE = "editable";
    public static final String PROPERTY_HEIGHT = "height";
    public static final String PROPERTY_HORIZONTAL_SCROLL = "horizontalScroll";
    public static final String PROPERTY_INSETS = "insets";
    public static final String PROPERTY_MAXIMUM_LENGTH = "maximumLength";
    public static final String PROPERTY_READONLY_BACKGROUND = "readOnlyBackground";
    public static final String PROPERTY_READONLY_BACKGROUND_IMAGE = "readOnlyBackgroundImage";
    public static final String PROPERTY_READONLY_BORDER = "readOnlyBorder";
    public static final String PROPERTY_READONLY_FONT = "readOnlyFont";
    public static final String PROPERTY_READONLY_FOREGROUND = "readOnlyForeground";
    public static final String PROPERTY_TOOL_TIP_TEXT = "toolTipText";
    public static final String PROPERTY_VERTICAL_SCROLL = "verticalScroll";
    public static final String PROPERTY_WIDTH = "width";
    public static final String ACTION_LISTENERS_CHANGED_PROPERTY = "actionListeners";
    public static final String DOCUMENT_CHANGED_PROPERTY = "document";
    public static final String TEXT_CHANGED_PROPERTY = "text";
    private Document document;
    private DocumentListener documentListener = new DocumentListener(){
        private static final long serialVersionUID = 20070101L;

        public void documentUpdate(DocumentEvent e) {
            TextComponent.this.firePropertyChange(TextComponent.TEXT_CHANGED_PROPERTY, null, ((Document)e.getSource()).getText());
        }
    };

    public TextComponent(Document document) {
        this.setDocument(document);
    }

    public void addActionListener(ActionListener l) {
        this.getEventListenerList().addListener(ActionListener.class, l);
        this.firePropertyChange(ACTION_LISTENERS_CHANGED_PROPERTY, null, l);
    }

    private void fireActionEvent() {
        if (!this.hasEventListenerList()) {
            return;
        }
        EventListener[] listeners = this.getEventListenerList().getListeners(ActionListener.class);
        ActionEvent e = null;
        for (int i = 0; i < listeners.length; ++i) {
            if (e == null) {
                e = new ActionEvent(this, (String)this.getRenderProperty(PROPERTY_ACTION_COMMAND));
            }
            ((ActionListener)listeners[i]).actionPerformed(e);
        }
    }

    public String getActionCommand() {
        return (String)this.get(PROPERTY_ACTION_COMMAND);
    }

    public Alignment getAlignment() {
        return (Alignment)this.get(PROPERTY_ALIGNMENT);
    }

    public FillImage getBackgroundImage() {
        return (FillImage)this.get(PROPERTY_BACKGROUND_IMAGE);
    }

    public Color getDisabledBackground() {
        return (Color)this.get(PROPERTY_DISABLED_BACKGROUND);
    }

    public FillImage getDisabledBackgroundImage() {
        return (FillImage)this.get(PROPERTY_DISABLED_BACKGROUND_IMAGE);
    }

    public Border getDisabledBorder() {
        return (Border)this.get(PROPERTY_DISABLED_BORDER);
    }

    public Font getDisabledFont() {
        return (Font)this.get(PROPERTY_DISABLED_FONT);
    }

    public Color getDisabledForeground() {
        return (Color)this.get(PROPERTY_DISABLED_FOREGROUND);
    }

    public Document getDocument() {
        return this.document;
    }

    public Extent getHeight() {
        return (Extent)this.get(PROPERTY_HEIGHT);
    }

    public Extent getHorizontalScroll() {
        return (Extent)this.get(PROPERTY_HORIZONTAL_SCROLL);
    }

    public Insets getInsets() {
        return (Insets)this.get(PROPERTY_INSETS);
    }

    public int getMaximumLength() {
        Integer value = (Integer)this.get(PROPERTY_MAXIMUM_LENGTH);
        return value == null ? -1 : value;
    }

    public Color getReadOnlyBackground() {
        return (Color)this.get(PROPERTY_READONLY_BACKGROUND);
    }

    public FillImage getReadOnlyBackgroundImage() {
        return (FillImage)this.get(PROPERTY_READONLY_BACKGROUND_IMAGE);
    }

    public Border getReadOnlyBorder() {
        return (Border)this.get(PROPERTY_READONLY_BORDER);
    }

    public Font getReadOnlyFont() {
        return (Font)this.get(PROPERTY_READONLY_FONT);
    }

    public Color getReadOnlyForeground() {
        return (Color)this.get(PROPERTY_READONLY_FOREGROUND);
    }

    public String getText() {
        return this.document.getText();
    }

    public String getToolTipText() {
        return (String)this.get(PROPERTY_TOOL_TIP_TEXT);
    }

    public Extent getVerticalScroll() {
        return (Extent)this.get(PROPERTY_VERTICAL_SCROLL);
    }

    public Extent getWidth() {
        return (Extent)this.get(PROPERTY_WIDTH);
    }

    public boolean hasActionListeners() {
        return this.hasEventListenerList() && this.getEventListenerList().getListenerCount(ActionListener.class) != 0;
    }

    public boolean isEditable() {
        Object property = this.get(PROPERTY_EDITABLE);
        return null == property ? true : (Boolean)property;
    }

    public boolean isValidChild(Component component) {
        return false;
    }

    public void processInput(String inputName, Object inputValue) {
        super.processInput(inputName, inputValue);
        if (TEXT_CHANGED_PROPERTY.equals(inputName)) {
            this.setText((String)inputValue);
        } else if (PROPERTY_HORIZONTAL_SCROLL.equals(inputName)) {
            this.setHorizontalScroll((Extent)inputValue);
        } else if (PROPERTY_VERTICAL_SCROLL.equals(inputName)) {
            this.setVerticalScroll((Extent)inputValue);
        } else if (INPUT_ACTION.equals(inputName)) {
            this.fireActionEvent();
        }
    }

    public void removeActionListener(ActionListener l) {
        if (!this.hasEventListenerList()) {
            return;
        }
        this.getEventListenerList().removeListener(ActionListener.class, l);
        this.firePropertyChange(ACTION_LISTENERS_CHANGED_PROPERTY, l, null);
    }

    public void setActionCommand(String newValue) {
        this.set(PROPERTY_ACTION_COMMAND, newValue);
    }

    public void setAlignment(Alignment newValue) {
        this.set(PROPERTY_ALIGNMENT, newValue);
    }

    public void setBackgroundImage(FillImage newValue) {
        this.set(PROPERTY_BACKGROUND_IMAGE, newValue);
    }

    public void setDisabledBackground(Color newValue) {
        this.set(PROPERTY_DISABLED_BACKGROUND, newValue);
    }

    public void setDisabledBackgroundImage(FillImage newValue) {
        this.set(PROPERTY_DISABLED_BACKGROUND_IMAGE, newValue);
    }

    public void setDisabledBorder(Border newValue) {
        this.set(PROPERTY_DISABLED_BORDER, newValue);
    }

    public void setDisabledFont(Font newValue) {
        this.set(PROPERTY_DISABLED_FONT, newValue);
    }

    public void setDisabledForeground(Color newValue) {
        this.set(PROPERTY_DISABLED_FOREGROUND, newValue);
    }

    public void setDocument(Document newValue) {
        if (newValue == null) {
            throw new IllegalArgumentException("Document may not be null.");
        }
        Document oldValue = this.getDocument();
        if (oldValue != null) {
            oldValue.removeDocumentListener(this.documentListener);
        }
        newValue.addDocumentListener(this.documentListener);
        this.document = newValue;
    }

    public void setEditable(boolean newValue) {
        this.set(PROPERTY_EDITABLE, newValue);
    }

    public void setHeight(Extent newValue) {
        this.set(PROPERTY_HEIGHT, newValue);
    }

    public void setHorizontalScroll(Extent newValue) {
        this.set(PROPERTY_HORIZONTAL_SCROLL, newValue);
    }

    public void setInsets(Insets newValue) {
        this.set(PROPERTY_INSETS, newValue);
    }

    public void setMaximumLength(int newValue) {
        if (newValue < 0) {
            this.set(PROPERTY_MAXIMUM_LENGTH, null);
        } else {
            this.set(PROPERTY_MAXIMUM_LENGTH, new Integer(newValue));
        }
    }

    public void setReadOnlyBackground(Color newValue) {
        this.set(PROPERTY_READONLY_BACKGROUND, newValue);
    }

    public void setReadOnlyBackgroundImage(FillImage newValue) {
        this.set(PROPERTY_READONLY_BACKGROUND_IMAGE, newValue);
    }

    public void setReadOnlyBorder(Border newValue) {
        this.set(PROPERTY_READONLY_BORDER, newValue);
    }

    public void setReadOnlyFont(Font newValue) {
        this.set(PROPERTY_READONLY_FONT, newValue);
    }

    public void setReadOnlyForeground(Color newValue) {
        this.set(PROPERTY_READONLY_FOREGROUND, newValue);
    }

    public void setText(String newValue) {
        Integer maxLength = (Integer)this.get(PROPERTY_MAXIMUM_LENGTH);
        if (newValue != null && maxLength != null && maxLength > 0 && newValue.length() > maxLength) {
            this.getDocument().setText(newValue.substring(0, maxLength));
        } else {
            this.getDocument().setText(newValue);
        }
    }

    public void setToolTipText(String newValue) {
        this.set(PROPERTY_TOOL_TIP_TEXT, newValue);
    }

    public void setVerticalScroll(Extent newValue) {
        this.set(PROPERTY_VERTICAL_SCROLL, newValue);
    }

    public void setWidth(Extent newValue) {
        this.set(PROPERTY_WIDTH, newValue);
    }
}

