/*
 * Decompiled with CFR 0.152.
 */
package nextapp.echo.app.serial.property;

import nextapp.echo.app.reflect.IntrospectorFactory;
import nextapp.echo.app.reflect.ObjectIntrospector;
import nextapp.echo.app.serial.SerialContext;
import nextapp.echo.app.serial.SerialException;
import nextapp.echo.app.serial.SerialPropertyPeer;
import nextapp.echo.app.util.Context;
import nextapp.echo.app.util.DomUtil;
import org.w3c.dom.Element;

public class IntegerPeer
implements SerialPropertyPeer {
    private Integer introspectConstantValue(Context context, Class objectClass, String value) throws SerialException {
        SerialContext serialContext = (SerialContext)context.get(SerialContext.class);
        try {
            Object constantValue;
            ObjectIntrospector introspector = IntrospectorFactory.get(objectClass.getName(), serialContext.getClassLoader());
            if (value.startsWith(objectClass.getName())) {
                value = value.substring(objectClass.getName().length() + 1);
            }
            if ((constantValue = introspector.getConstantValue(value)) instanceof Integer) {
                return (Integer)constantValue;
            }
            return null;
        }
        catch (ClassNotFoundException ex) {
            throw new SerialException("Object class not found.", ex);
        }
    }

    public Object toProperty(Context context, Class objectClass, Element propertyElement) throws SerialException {
        String valueText = propertyElement.hasAttribute("v") ? propertyElement.getAttribute("v") : DomUtil.getElementText(propertyElement);
        try {
            return new Integer(valueText);
        }
        catch (NumberFormatException ex) {
            return this.introspectConstantValue(context, objectClass, valueText);
        }
    }

    public void toXml(Context context, Class objectClass, Element propertyElement, Object propertyValue) throws SerialException {
        SerialContext serialContext = (SerialContext)context.get(SerialContext.class);
        propertyElement.setAttribute("t", "i");
        propertyElement.appendChild(serialContext.getDocument().createTextNode(propertyValue.toString()));
    }
}

