/*
 * Decompiled with CFR 0.152.
 */
package nextapp.echo.app.serial.property;

import nextapp.echo.app.BoxShadow;
import nextapp.echo.app.Color;
import nextapp.echo.app.Extent;
import nextapp.echo.app.serial.SerialContext;
import nextapp.echo.app.serial.SerialException;
import nextapp.echo.app.serial.SerialPropertyPeer;
import nextapp.echo.app.serial.property.ColorPeer;
import nextapp.echo.app.serial.property.ExtentPeer;
import nextapp.echo.app.util.Context;
import nextapp.echo.app.util.DomUtil;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class BoxShadowPeer
implements SerialPropertyPeer {
    public static final Node toNode(Context context, BoxShadow boxShadow) throws SerialException {
        SerialContext serialContext = (SerialContext)context.get(SerialContext.class);
        Element boxElement = serialContext.getDocument().createElement("box");
        boxElement.setAttribute("h", ExtentPeer.toString(boxShadow.getHorizontalShadowPosition()));
        boxElement.setAttribute("v", ExtentPeer.toString(boxShadow.getVerticalShadowPosition()));
        boxElement.setAttribute("b", ExtentPeer.toString(boxShadow.getBlurDistance()));
        boxElement.setAttribute("s", ExtentPeer.toString(boxShadow.getSpreadSize()));
        boxElement.setAttribute("c", ColorPeer.toString(boxShadow.getColor()));
        boxElement.setAttribute("i", boxShadow.getStyle().name());
        return boxElement;
    }

    public Object toProperty(Context context, Class objectClass, Element propertyElement) throws SerialException {
        Element boxElement = DomUtil.getChildElementByTagName(propertyElement, "box");
        Extent hShadow = ExtentPeer.fromString(boxElement.getAttribute("h"));
        Extent vShadow = ExtentPeer.fromString(boxElement.getAttribute("v"));
        Extent blurDistance = ExtentPeer.fromString(boxElement.getAttribute("b"));
        Extent spreadSize = ExtentPeer.fromString(boxElement.getAttribute("s"));
        Color color = ColorPeer.fromString(boxElement.getAttribute("v"));
        BoxShadow.BoxStyle style = BoxShadow.BoxStyle.valueOf(boxElement.getAttribute("i"));
        return new BoxShadow(hShadow, vShadow, blurDistance, spreadSize, color, style);
    }

    public void toXml(Context context, Class objectClass, Element propertyElement, Object propertyValue) throws SerialException {
        propertyElement.setAttribute("t", "BoxShadow");
        BoxShadow boxShadow = (BoxShadow)propertyValue;
        propertyElement.appendChild(BoxShadowPeer.toNode(context, boxShadow));
    }
}

