/*
 * Decompiled with CFR 0.152.
 */
package nextapp.echo.app;

import java.util.EventListener;
import nextapp.echo.app.BoxShadow;
import nextapp.echo.app.Color;
import nextapp.echo.app.Component;
import nextapp.echo.app.ContentPane;
import nextapp.echo.app.Extent;
import nextapp.echo.app.FillImage;
import nextapp.echo.app.FillImageBorder;
import nextapp.echo.app.FloatingPane;
import nextapp.echo.app.Font;
import nextapp.echo.app.ImageReference;
import nextapp.echo.app.Insets;
import nextapp.echo.app.ModalSupport;
import nextapp.echo.app.PaneContainer;
import nextapp.echo.app.event.WindowPaneControlListener;
import nextapp.echo.app.event.WindowPaneEvent;
import nextapp.echo.app.event.WindowPaneListener;

public class WindowPane
extends Component
implements FloatingPane,
ModalSupport,
PaneContainer {
    private static final long serialVersionUID = 20070101L;
    public static final String INPUT_CLOSE = "close";
    public static final String INPUT_MINIMIZE = "minimize";
    public static final String INPUT_MAXIMIZE = "maximize";
    public static final String PROPERTY_BACKGROUND_IMAGE = "backgroundImage";
    public static final String PROPERTY_BORDER = "border";
    public static final String PROPERTY_BOX_SHADOW = "boxShadow";
    public static final String PROPERTY_CLOSABLE = "closable";
    public static final String PROPERTY_CLOSE_ANIMATION_TIME = "closeAnimationTime";
    public static final String PROPERTY_CLOSE_ICON = "closeIcon";
    public static final String PROPERTY_CLOSE_ICON_INSETS = "closeIconInsets";
    public static final String PROPERTY_CLOSE_ROLLOVER_ICON = "closeRolloverIcon";
    public static final String PROPERTY_CONTENT_HEIGHT = "contentHeight";
    public static final String PROPERTY_CONTENT_WIDTH = "contentWidth";
    public static final String PROPERTY_CONTROLS_INSETS = "controlsInsets";
    public static final String PROPERTY_CONTROLS_SPACING = "controlsSpacing";
    public static final String PROPERTY_DEFAULT_CLOSE_OPERATION = "defaultCloseOperation";
    public static final String PROPERTY_HEIGHT = "height";
    public static final String PROPERTY_ICON = "icon";
    public static final String PROPERTY_ICON_INSETS = "iconInsets";
    public static final String PROPERTY_INSETS = "insets";
    public static final String PROPERTY_MAXIMIZE_ENABLED = "maximizeEnabled";
    public static final String PROPERTY_MAXIMIZE_ICON = "maximizeIcon";
    public static final String PROPERTY_MAXIMIZE_ICON_INSETS = "maximizeIconInsets";
    public static final String PROPERTY_MAXIMIZE_ROLLOVER_ICON = "maximizeRolloverIcon";
    public static final String PROPERTY_MAXIMUM_HEIGHT = "maximumHeight";
    public static final String PROPERTY_MAXIMUM_WIDTH = "maximumWidth";
    public static final String PROPERTY_MINIMIZE_ENABLED = "minimizeEnabled";
    public static final String PROPERTY_MINIMIZE_ICON = "minimizeIcon";
    public static final String PROPERTY_MINIMIZE_ICON_INSETS = "minimizeIconInsets";
    public static final String PROPERTY_MINIMIZE_ROLLOVER_ICON = "minimizeRolloverIcon";
    public static final String PROPERTY_MINIMUM_HEIGHT = "minimumHeight";
    public static final String PROPERTY_MINIMUM_WIDTH = "minimumWidth";
    public static final String PROPERTY_MOVABLE = "movable";
    public static final String PROPERTY_OPEN_ANIMATION_TIME = "openAnimationTime";
    public static final String PROPERTY_POSITION_X = "positionX";
    public static final String PROPERTY_POSITION_Y = "positionY";
    public static final String PROPERTY_RADIUS = "radius";
    public static final String PROPERTY_RESIZABLE = "resizable";
    public static final String PROPERTY_TITLE = "title";
    public static final String PROPERTY_TITLE_BACKGROUND = "titleBackground";
    public static final String PROPERTY_TITLE_BACKGROUND_IMAGE = "titleBackgroundImage";
    public static final String PROPERTY_TITLE_FONT = "titleFont";
    public static final String PROPERTY_TITLE_FOREGROUND = "titleForeground";
    public static final String PROPERTY_TITLE_HEIGHT = "titleHeight";
    public static final String PROPERTY_TITLE_INSETS = "titleInsets";
    public static final String PROPERTY_WIDTH = "width";
    public static final String PROPERTY_Z_INDEX = "zIndex";
    public static final int DO_NOTHING_ON_CLOSE = 0;
    public static final int HIDE_ON_CLOSE = 1;
    public static final int DISPOSE_ON_CLOSE = 2;
    private boolean modal = false;

    public WindowPane() {
        this(null, null, null);
    }

    public WindowPane(String title, Extent width, Extent height) {
        if (title != null) {
            this.setTitle(title);
        }
        if (width != null) {
            this.setWidth(width);
        }
        if (height != null) {
            this.setHeight(height);
        }
    }

    public void addWindowPaneListener(WindowPaneListener l) {
        this.getEventListenerList().addListener(WindowPaneListener.class, l);
    }

    protected void fireWindowClosing() {
        if (!this.hasEventListenerList()) {
            return;
        }
        EventListener[] listeners = this.getEventListenerList().getListeners(WindowPaneListener.class);
        if (listeners.length == 0) {
            return;
        }
        WindowPaneEvent e = new WindowPaneEvent(this);
        for (int i = 0; i < listeners.length; ++i) {
            ((WindowPaneListener)listeners[i]).windowPaneClosing(e);
        }
    }

    protected void fireWindowMaximized() {
        if (!this.hasEventListenerList()) {
            return;
        }
        EventListener[] listeners = this.getEventListenerList().getListeners(WindowPaneListener.class);
        if (listeners.length == 0) {
            return;
        }
        WindowPaneEvent e = new WindowPaneEvent(this);
        for (int i = 0; i < listeners.length; ++i) {
            if (!(listeners[i] instanceof WindowPaneControlListener)) continue;
            ((WindowPaneControlListener)listeners[i]).windowPaneMaximized(e);
        }
    }

    protected void fireWindowMinimized() {
        if (!this.hasEventListenerList()) {
            return;
        }
        EventListener[] listeners = this.getEventListenerList().getListeners(WindowPaneListener.class);
        if (listeners.length == 0) {
            return;
        }
        WindowPaneEvent e = new WindowPaneEvent(this);
        for (int i = 0; i < listeners.length; ++i) {
            if (!(listeners[i] instanceof WindowPaneControlListener)) continue;
            ((WindowPaneControlListener)listeners[i]).windowPaneMinimized(e);
        }
    }

    public FillImage getBackgroundImage() {
        return (FillImage)this.get(PROPERTY_BACKGROUND_IMAGE);
    }

    public FillImageBorder getBorder() {
        return (FillImageBorder)this.get(PROPERTY_BORDER);
    }

    public BoxShadow getBoxShadow() {
        return (BoxShadow)this.get(PROPERTY_BOX_SHADOW);
    }

    public int getCloseAnimationTime() {
        Integer animationTime = (Integer)this.get(PROPERTY_CLOSE_ANIMATION_TIME);
        return animationTime == null ? 0 : animationTime;
    }

    public ImageReference getCloseIcon() {
        return (ImageReference)this.get(PROPERTY_CLOSE_ICON);
    }

    public Insets getCloseIconInsets() {
        return (Insets)this.get(PROPERTY_CLOSE_ICON_INSETS);
    }

    public ImageReference getCloseRolloverIcon() {
        return (ImageReference)this.get(PROPERTY_CLOSE_ROLLOVER_ICON);
    }

    public Extent getContentHeight() {
        return (Extent)this.get(PROPERTY_HEIGHT);
    }

    public Extent getContentWidth() {
        return (Extent)this.get(PROPERTY_HEIGHT);
    }

    public Extent getControlsSpacing() {
        return (Extent)this.get(PROPERTY_CONTROLS_SPACING);
    }

    public Insets getControlsInsets() {
        return (Insets)this.get(PROPERTY_CONTROLS_INSETS);
    }

    public int getDefaultCloseOperation() {
        Integer defaultCloseOperationValue = (Integer)this.get(PROPERTY_DEFAULT_CLOSE_OPERATION);
        return defaultCloseOperationValue == null ? 0 : defaultCloseOperationValue;
    }

    public Extent getHeight() {
        return (Extent)this.get(PROPERTY_HEIGHT);
    }

    public ImageReference getIcon() {
        return (ImageReference)this.get(PROPERTY_ICON);
    }

    public Insets getIconInsets() {
        return (Insets)this.get(PROPERTY_ICON_INSETS);
    }

    public Insets getInsets() {
        return (Insets)this.get(PROPERTY_INSETS);
    }

    public ImageReference getMaximizeIcon() {
        return (ImageReference)this.get(PROPERTY_MAXIMIZE_ICON);
    }

    public Insets getMaximizeIconInsets() {
        return (Insets)this.get(PROPERTY_MAXIMIZE_ICON_INSETS);
    }

    public ImageReference getMaximizeRolloverIcon() {
        return (ImageReference)this.get(PROPERTY_MAXIMIZE_ROLLOVER_ICON);
    }

    public Extent getMaximumHeight() {
        return (Extent)this.get(PROPERTY_MAXIMUM_HEIGHT);
    }

    public Extent getMaximumWidth() {
        return (Extent)this.get(PROPERTY_MAXIMUM_WIDTH);
    }

    public ImageReference getMinimizeIcon() {
        return (ImageReference)this.get(PROPERTY_MINIMIZE_ICON);
    }

    public Insets getMinimizeIconInsets() {
        return (Insets)this.get(PROPERTY_MINIMIZE_ICON_INSETS);
    }

    public ImageReference getMinimizeRolloverIcon() {
        return (ImageReference)this.get(PROPERTY_MINIMIZE_ROLLOVER_ICON);
    }

    public Extent getMinimumHeight() {
        return (Extent)this.get(PROPERTY_MINIMUM_HEIGHT);
    }

    public Extent getMinimumWidth() {
        return (Extent)this.get(PROPERTY_MINIMUM_WIDTH);
    }

    public int getOpenAnimationTime() {
        Integer animationTime = (Integer)this.get(PROPERTY_OPEN_ANIMATION_TIME);
        return animationTime == null ? 0 : animationTime;
    }

    public Extent getPositionX() {
        return (Extent)this.get(PROPERTY_POSITION_X);
    }

    public Extent getPositionY() {
        return (Extent)this.get(PROPERTY_POSITION_Y);
    }

    public Insets getRadius() {
        return (Insets)this.get(PROPERTY_RADIUS);
    }

    public String getTitle() {
        return (String)this.get(PROPERTY_TITLE);
    }

    public Color getTitleBackground() {
        return (Color)this.get(PROPERTY_TITLE_BACKGROUND);
    }

    public FillImage getTitleBackgroundImage() {
        return (FillImage)this.get(PROPERTY_TITLE_BACKGROUND_IMAGE);
    }

    public Font getTitleFont() {
        return (Font)this.get(PROPERTY_TITLE_FONT);
    }

    public Color getTitleForeground() {
        return (Color)this.get(PROPERTY_TITLE_FOREGROUND);
    }

    public Extent getTitleHeight() {
        return (Extent)this.get(PROPERTY_TITLE_HEIGHT);
    }

    public Insets getTitleInsets() {
        return (Insets)this.get(PROPERTY_TITLE_INSETS);
    }

    public Extent getWidth() {
        return (Extent)this.get(PROPERTY_WIDTH);
    }

    public int getZIndex() {
        Integer value = (Integer)this.get(PROPERTY_Z_INDEX);
        return value == null ? -1 : value;
    }

    public boolean isClosable() {
        Boolean value = (Boolean)this.get(PROPERTY_CLOSABLE);
        return value == null ? true : value;
    }

    public boolean isMaximizeEnabled() {
        Boolean value = (Boolean)this.get(PROPERTY_MAXIMIZE_ENABLED);
        return value == null ? true : value;
    }

    public boolean isMinimizeEnabled() {
        Boolean value = (Boolean)this.get(PROPERTY_MINIMIZE_ENABLED);
        return value == null ? true : value;
    }

    public boolean isModal() {
        return this.modal;
    }

    public boolean isMovable() {
        Boolean value = (Boolean)this.get(PROPERTY_MOVABLE);
        return value == null ? true : value;
    }

    public boolean isResizable() {
        Boolean value = (Boolean)this.get(PROPERTY_RESIZABLE);
        return value == null ? true : value;
    }

    public boolean isValidChild(Component component) {
        return this.getComponentCount() == 0;
    }

    public boolean isValidParent(Component parent) {
        return parent instanceof ContentPane;
    }

    public void processInput(String inputName, Object inputValue) {
        if (INPUT_CLOSE.equals(inputName)) {
            this.userClose();
        } else if (INPUT_MAXIMIZE.equals(inputName)) {
            this.userMaximize();
        } else if (INPUT_MINIMIZE.equals(inputName)) {
            this.userMinimize();
        } else if (PROPERTY_POSITION_X.equals(inputName)) {
            this.setPositionX((Extent)inputValue);
        } else if (PROPERTY_POSITION_Y.equals(inputName)) {
            this.setPositionY((Extent)inputValue);
        } else if (PROPERTY_WIDTH.equals(inputName)) {
            this.setWidth((Extent)inputValue);
        } else if (PROPERTY_HEIGHT.equals(inputName)) {
            this.setHeight((Extent)inputValue);
        } else if (PROPERTY_Z_INDEX.equals(inputName)) {
            this.set(PROPERTY_Z_INDEX, (Integer)inputValue);
        }
    }

    public void removeWindowPaneListener(WindowPaneListener l) {
        if (!this.hasEventListenerList()) {
            return;
        }
        this.getEventListenerList().removeListener(WindowPaneListener.class, l);
    }

    public void setBackgroundImage(FillImage newValue) {
        this.set(PROPERTY_BACKGROUND_IMAGE, newValue);
    }

    public void setBorder(FillImageBorder newValue) {
        this.set(PROPERTY_BORDER, newValue);
    }

    public void setBoxShadow(BoxShadow newValue) {
        this.set(PROPERTY_BOX_SHADOW, newValue);
    }

    public void setClosable(boolean newValue) {
        this.set(PROPERTY_CLOSABLE, new Boolean(newValue));
    }

    public void setCloseAnimationTime(int newValue) {
        this.set(PROPERTY_CLOSE_ANIMATION_TIME, new Integer(newValue));
    }

    public void setCloseIcon(ImageReference newValue) {
        this.set(PROPERTY_CLOSE_ICON, newValue);
    }

    public void setCloseIconInsets(Insets newValue) {
        this.set(PROPERTY_CLOSE_ICON_INSETS, newValue);
    }

    public void setCloseRolloverIcon(ImageReference newValue) {
        this.set(PROPERTY_CLOSE_ROLLOVER_ICON, newValue);
    }

    public void setContentHeight(Extent newValue) {
        this.set(PROPERTY_CONTENT_HEIGHT, newValue);
    }

    public void setContentWidth(Extent newValue) {
        this.set(PROPERTY_CONTENT_WIDTH, newValue);
    }

    public void setControlsSpacing(Extent newValue) {
        this.set(PROPERTY_CONTROLS_SPACING, newValue);
    }

    public void setControlsInsets(Insets newValue) {
        this.set(PROPERTY_CONTROLS_INSETS, newValue);
    }

    public void setDefaultCloseOperation(int newValue) {
        this.set(PROPERTY_DEFAULT_CLOSE_OPERATION, new Integer(newValue));
    }

    public void setHeight(Extent newValue) {
        this.set(PROPERTY_HEIGHT, newValue);
    }

    public void setIcon(ImageReference newValue) {
        this.set(PROPERTY_ICON, newValue);
    }

    public void setIconInsets(Insets newValue) {
        this.set(PROPERTY_ICON_INSETS, newValue);
    }

    public void setInsets(Insets newValue) {
        this.set(PROPERTY_INSETS, newValue);
    }

    public void setMaximizeEnabled(boolean newValue) {
        this.set(PROPERTY_MAXIMIZE_ENABLED, new Boolean(newValue));
    }

    public void setMaximizeIcon(ImageReference newValue) {
        this.set(PROPERTY_MAXIMIZE_ICON, newValue);
    }

    public void setMaximizeIconInsets(Insets newValue) {
        this.set(PROPERTY_MAXIMIZE_ICON_INSETS, newValue);
    }

    public void setMaximizeRolloverIcon(ImageReference newValue) {
        this.set(PROPERTY_MAXIMIZE_ROLLOVER_ICON, newValue);
    }

    public void setMaximumHeight(Extent newValue) {
        this.set(PROPERTY_MAXIMUM_HEIGHT, newValue);
    }

    public void setMaximumWidth(Extent newValue) {
        this.set(PROPERTY_MAXIMUM_WIDTH, newValue);
    }

    public void setMinimizeEnabled(boolean newValue) {
        this.set(PROPERTY_MINIMIZE_ENABLED, new Boolean(newValue));
    }

    public void setMinimizeIcon(ImageReference newValue) {
        this.set(PROPERTY_MINIMIZE_ICON, newValue);
    }

    public void setMinimizeIconInsets(Insets newValue) {
        this.set(PROPERTY_MINIMIZE_ICON_INSETS, newValue);
    }

    public void setMinimizeRolloverIcon(ImageReference newValue) {
        this.set(PROPERTY_MINIMIZE_ROLLOVER_ICON, newValue);
    }

    public void setMinimumHeight(Extent newValue) {
        this.set(PROPERTY_MINIMUM_HEIGHT, newValue);
    }

    public void setMinimumWidth(Extent newValue) {
        this.set(PROPERTY_MINIMUM_WIDTH, newValue);
    }

    public void setModal(boolean newValue) {
        boolean oldValue = this.modal;
        this.modal = newValue;
        this.firePropertyChange("modal", new Boolean(oldValue), new Boolean(newValue));
    }

    public void setMovable(boolean newValue) {
        this.set(PROPERTY_MOVABLE, new Boolean(newValue));
    }

    public void setOpenAnimationTime(int newValue) {
        this.set(PROPERTY_OPEN_ANIMATION_TIME, new Integer(newValue));
    }

    public void setPositionX(Extent newValue) {
        this.set(PROPERTY_POSITION_X, newValue);
    }

    public void setPositionY(Extent newValue) {
        this.set(PROPERTY_POSITION_Y, newValue);
    }

    public void setRadius(Insets newValue) {
        this.set(PROPERTY_RADIUS, newValue);
    }

    public void setResizable(boolean newValue) {
        this.set(PROPERTY_RESIZABLE, new Boolean(newValue));
    }

    public void setTitle(String newValue) {
        this.set(PROPERTY_TITLE, newValue);
    }

    public void setTitleFont(Font newValue) {
        this.set(PROPERTY_TITLE_FONT, newValue);
    }

    public void setTitleBackground(Color newValue) {
        this.set(PROPERTY_TITLE_BACKGROUND, newValue);
    }

    public void setTitleBackgroundImage(FillImage newValue) {
        this.set(PROPERTY_TITLE_BACKGROUND_IMAGE, newValue);
    }

    public void setTitleForeground(Color newValue) {
        this.set(PROPERTY_TITLE_FOREGROUND, newValue);
    }

    public void setTitleHeight(Extent newValue) {
        this.set(PROPERTY_TITLE_HEIGHT, newValue);
    }

    public void setTitleInsets(Insets newValue) {
        this.set(PROPERTY_TITLE_INSETS, newValue);
    }

    public void setWidth(Extent newValue) {
        this.set(PROPERTY_WIDTH, newValue);
    }

    public void setZIndex(int newValue) {
        this.set(PROPERTY_Z_INDEX, new Integer(newValue));
    }

    public void userClose() {
        this.fireWindowClosing();
        Integer defaultCloseOperationValue = (Integer)this.getRenderProperty(PROPERTY_DEFAULT_CLOSE_OPERATION);
        int defaultCloseOperation = defaultCloseOperationValue == null ? 2 : defaultCloseOperationValue;
        switch (defaultCloseOperation) {
            case 2: {
                this.getParent().remove(this);
                break;
            }
            case 1: {
                this.setVisible(false);
            }
        }
    }

    public void userMaximize() {
        this.fireWindowMaximized();
    }

    public void userMinimize() {
        this.setVisible(false);
        this.fireWindowMinimized();
    }
}

