/*
 * Decompiled with CFR 0.152.
 */
package nextapp.echo.app;

import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Locale;

public class LayoutDirection
implements Serializable {
    private static final long serialVersionUID = 20070101L;
    private static final Collection RTL_LANGUAGES;
    public static final LayoutDirection LTR;
    public static final LayoutDirection RTL;
    private boolean leftToRight;

    public static LayoutDirection forLocale(Locale locale) {
        return RTL_LANGUAGES.contains(locale.getLanguage()) ? RTL : LTR;
    }

    private LayoutDirection(boolean leftToRight) {
        this.leftToRight = leftToRight;
    }

    public boolean isLeftToRight() {
        return this.leftToRight;
    }

    public String toString() {
        return this.leftToRight ? "LTR" : "RTL";
    }

    static {
        HashSet<String> rtlLanguages = new HashSet<String>();
        rtlLanguages.add("ar");
        rtlLanguages.add("fa");
        rtlLanguages.add("iw");
        rtlLanguages.add("ur");
        RTL_LANGUAGES = Collections.unmodifiableCollection(rtlLanguages);
        LTR = new LayoutDirection(true);
        RTL = new LayoutDirection(false);
    }
}

