/*
 * Decompiled with CFR 0.152.
 */
package nextapp.echo.app.util;

import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Properties;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class DomUtil {
    public static final Properties OUTPUT_PROPERTIES_INDENT = new Properties();
    private static final EntityResolver entityResolver;
    private static final ThreadLocal documentBuilders;
    private static final ThreadLocal transformerFactories;

    public static Document createDocument(String qualifiedName, String publicId, String systemId, String namespaceUri) {
        DOMImplementation dom = DomUtil.getDocumentBuilder().getDOMImplementation();
        DocumentType docType = dom.createDocumentType(qualifiedName, publicId, systemId);
        Document document = dom.createDocument(namespaceUri, qualifiedName, docType);
        if (namespaceUri != null) {
            document.getDocumentElement().setAttribute("xmlns", namespaceUri);
        }
        return document;
    }

    public static DocumentBuilder getDocumentBuilder() {
        return (DocumentBuilder)documentBuilders.get();
    }

    public static TransformerFactory getTransformerFactory() {
        return (TransformerFactory)transformerFactories.get();
    }

    public static boolean getBooleanAttribute(Element element, String attributeName) {
        String value = element.getAttribute(attributeName);
        if (value == null) {
            return false;
        }
        return value.equals("true");
    }

    public static Element getChildElementByTagName(Element parentElement, String name) {
        NodeList nodes = parentElement.getChildNodes();
        int length = nodes.getLength();
        for (int index = 0; index < length; ++index) {
            if (nodes.item(index).getNodeType() != 1 || !name.equals(nodes.item(index).getNodeName())) continue;
            return (Element)nodes.item(index);
        }
        return null;
    }

    public static Element[] getChildElementsByTagName(Element parentElement, String name) {
        ArrayList<Node> children = new ArrayList<Node>();
        NodeList nodes = parentElement.getChildNodes();
        int length = nodes.getLength();
        for (int index = 0; index < length; ++index) {
            if (nodes.item(index).getNodeType() != 1 || !name.equals(nodes.item(index).getNodeName())) continue;
            children.add(nodes.item(index));
        }
        Element[] childElements = new Element[children.size()];
        return children.toArray(childElements);
    }

    public static int getChildElementCountByTagName(Element parentElement, String name) {
        NodeList nodes = parentElement.getChildNodes();
        int length = nodes.getLength();
        int count = 0;
        for (int index = 0; index < length; ++index) {
            if (nodes.item(index).getNodeType() != 1 || !name.equals(nodes.item(index).getNodeName())) continue;
            ++count;
        }
        return count;
    }

    public static String getElementText(Element element) {
        NodeList children = element.getChildNodes();
        int childCount = children.getLength();
        for (int index = 0; index < childCount; ++index) {
            if (!(children.item(index) instanceof Text)) continue;
            Text text = (Text)children.item(index);
            return text.getData();
        }
        return null;
    }

    public static void save(Document document, OutputStream out, Properties outputProperties) throws SAXException {
        DomUtil.saveImpl(document, new StreamResult(out), outputProperties);
    }

    public static void save(Document document, PrintWriter w, Properties outputProperties) throws SAXException {
        DomUtil.saveImpl(document, new StreamResult(w), outputProperties);
    }

    private static void saveImpl(Document document, StreamResult output, Properties outputProperties) throws SAXException {
        try {
            TransformerFactory tFactory = DomUtil.getTransformerFactory();
            Transformer transformer = tFactory.newTransformer();
            if (outputProperties != null) {
                transformer.setOutputProperties(outputProperties);
            }
            DOMSource source = new DOMSource(document);
            transformer.transform(source, output);
        }
        catch (TransformerException ex) {
            throw new SAXException("Unable to write document to OutputStream.", ex);
        }
    }

    public static void setElementText(Element element, String value) {
        NodeList children = element.getChildNodes();
        int childCount = children.getLength();
        for (int index = 0; index < childCount; ++index) {
            if (!(children.item(index) instanceof Text)) continue;
            Text text = (Text)children.item(index);
            text.setData(value);
            return;
        }
        Text text = element.getOwnerDocument().createTextNode(value);
        element.appendChild(text);
    }

    private DomUtil() {
    }

    static {
        OUTPUT_PROPERTIES_INDENT.setProperty("indent", "yes");
        OUTPUT_PROPERTIES_INDENT.setProperty("{http://xml.apache.org/xalan}indent-amount", "4");
        entityResolver = new EntityResolver(){

            public InputSource resolveEntity(String publicId, String systemId) throws SAXException, IOException {
                throw new SAXException("External entities not supported.");
            }
        };
        documentBuilders = new ThreadLocal(){

            protected Object initialValue() {
                try {
                    DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
                    factory.setNamespaceAware(true);
                    DocumentBuilder builder = factory.newDocumentBuilder();
                    builder.setEntityResolver(entityResolver);
                    return builder;
                }
                catch (ParserConfigurationException ex) {
                    throw new RuntimeException(ex);
                }
            }
        };
        transformerFactories = new ThreadLocal(){

            protected Object initialValue() {
                TransformerFactory factory = TransformerFactory.newInstance();
                return factory;
            }
        };
    }
}

