/*
 * Decompiled with CFR 0.152.
 */
package nextapp.echo.app.update;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import nextapp.echo.app.ApplicationInstance;
import nextapp.echo.app.Component;
import nextapp.echo.app.update.ClientComponentUpdate;

public class ClientUpdateManager
implements Serializable {
    private static final long serialVersionUID = 20070101L;
    private Map clientComponentUpdateMap = new HashMap();
    private Map applicationUpdateMap = new HashMap();
    private Component actionComponent;
    private String actionName;
    private Object actionValue;
    private ApplicationInstance applicationInstance;

    ClientUpdateManager(ApplicationInstance applicationInstance) {
        this.applicationInstance = applicationInstance;
    }

    ClientComponentUpdate getComponentUpdate(Component component) {
        return (ClientComponentUpdate)this.clientComponentUpdateMap.get(component);
    }

    Object getApplicationUpdatePropertyValue(String propertyName) {
        return this.applicationUpdateMap.get(propertyName);
    }

    void process() {
        Iterator applicationUpdateIt = this.applicationUpdateMap.keySet().iterator();
        while (applicationUpdateIt.hasNext()) {
            String propertyName = (String)applicationUpdateIt.next();
            Object propertyValue = this.applicationUpdateMap.get(propertyName);
            this.applicationInstance.processInput(propertyName, propertyValue);
        }
        Iterator componentUpdateIt = this.clientComponentUpdateMap.values().iterator();
        while (componentUpdateIt.hasNext()) {
            ClientComponentUpdate update = (ClientComponentUpdate)componentUpdateIt.next();
            Iterator inputNameIt = update.getInputNames();
            while (inputNameIt.hasNext()) {
                String inputName = (String)inputNameIt.next();
                update.getComponent().processInput(inputName, update.getInputValue(inputName));
            }
        }
        if (this.actionComponent != null) {
            this.actionComponent.processInput(this.actionName, this.actionValue);
        }
    }

    void purge() {
        this.clientComponentUpdateMap.clear();
        this.applicationUpdateMap.clear();
        this.actionComponent = null;
        this.actionName = null;
        this.actionValue = null;
    }

    public void setApplicationProperty(String propertyName, Object propertyValue) {
        this.applicationUpdateMap.put(propertyName, propertyValue);
    }

    public void setComponentAction(Component actionComponent, String actionName, Object actionValue) {
        if (!actionComponent.verifyInput(actionName, actionValue)) {
            return;
        }
        this.actionComponent = actionComponent;
        this.actionName = actionName;
        this.actionValue = actionValue;
    }

    public void setComponentProperty(Component component, String inputName, Object inputValue) {
        if (!component.verifyInput(inputName, inputValue)) {
            return;
        }
        ClientComponentUpdate clientUpdate = (ClientComponentUpdate)this.clientComponentUpdateMap.get(component);
        if (clientUpdate == null) {
            clientUpdate = new ClientComponentUpdate(component);
            this.clientComponentUpdateMap.put(component, clientUpdate);
        }
        clientUpdate.addInput(inputName, inputValue);
    }
}

