/*
 * Decompiled with CFR 0.152.
 */
package nextapp.echo.app;

import java.io.Serializable;
import nextapp.echo.app.Color;
import nextapp.echo.app.FillImage;
import nextapp.echo.app.Insets;

public class FillImageBorder
implements Serializable {
    private static final long serialVersionUID = 20070101L;
    public static final int TOP_LEFT = 0;
    public static final int TOP = 1;
    public static final int TOP_RIGHT = 2;
    public static final int LEFT = 3;
    public static final int RIGHT = 4;
    public static final int BOTTOM_LEFT = 5;
    public static final int BOTTOM = 6;
    public static final int BOTTOM_RIGHT = 7;
    private Insets contentInsets;
    private Insets borderInsets;
    private Color color;
    private FillImage[] fillImages;

    public FillImageBorder() {
    }

    public FillImageBorder(Color color, Insets borderInsets, Insets contentInsets) {
        this(color, borderInsets, contentInsets, null);
    }

    public FillImageBorder(Color color, Insets borderInsets, Insets contentInsets, FillImage[] fillImages) {
        this.color = color;
        this.borderInsets = borderInsets;
        this.contentInsets = contentInsets;
        if (fillImages != null) {
            this.fillImages = new FillImage[8];
            System.arraycopy(fillImages, 0, this.fillImages, 0, fillImages.length < 8 ? fillImages.length : 8);
        }
    }

    public boolean equals(Object o) {
        if (!(o instanceof FillImageBorder)) {
            return false;
        }
        FillImageBorder that = (FillImageBorder)o;
        if (!(this.color == that.color || this.color != null && this.color.equals(that.color))) {
            return false;
        }
        if (!(this.borderInsets == that.borderInsets || this.borderInsets != null && this.borderInsets.equals(that.borderInsets))) {
            return false;
        }
        if (!(this.contentInsets == that.contentInsets || this.contentInsets != null && this.contentInsets.equals(that.contentInsets))) {
            return false;
        }
        if (this.fillImages != null || that.fillImages != null) {
            if (this.fillImages == null || that.fillImages == null) {
                return false;
            }
            for (int i = 0; i < this.fillImages.length; ++i) {
                if (this.fillImages[i] == that.fillImages[i] || this.fillImages[i] != null && this.fillImages[i].equals(that.fillImages[i])) continue;
                return false;
            }
        }
        return true;
    }

    public Insets getBorderInsets() {
        return this.borderInsets;
    }

    public Color getColor() {
        return this.color;
    }

    public Insets getContentInsets() {
        return this.contentInsets;
    }

    public FillImage getFillImage(int position) {
        if (this.fillImages == null) {
            return null;
        }
        return this.fillImages[position];
    }

    public boolean hasFillImages() {
        return this.fillImages != null;
    }

    public void setBorderInsets(Insets borderInsets) {
        this.borderInsets = borderInsets;
    }

    public void setColor(Color color) {
        this.color = color;
    }

    public void setContentInsets(Insets contentInsets) {
        this.contentInsets = contentInsets;
    }

    public void setFillImage(int position, FillImage fillImage) {
        if (this.fillImages == null) {
            if (fillImage == null) {
                return;
            }
            this.fillImages = new FillImage[8];
        }
        this.fillImages[position] = fillImage;
        if (fillImage == null) {
            boolean hasFillImages = false;
            for (int i = 0; i < this.fillImages.length; ++i) {
                if (this.fillImages[i] == null) continue;
                hasFillImages = true;
                break;
            }
            if (!hasFillImages) {
                this.fillImages = null;
            }
        }
    }
}

