/*
 * Decompiled with CFR 0.152.
 */
package nextapp.echo.app.serial.property;

import nextapp.echo.app.Extent;
import nextapp.echo.app.FillImage;
import nextapp.echo.app.HttpImageReference;
import nextapp.echo.app.ImageReference;
import nextapp.echo.app.ResourceImageReference;
import nextapp.echo.app.serial.PropertyPeerFactory;
import nextapp.echo.app.serial.SerialContext;
import nextapp.echo.app.serial.SerialException;
import nextapp.echo.app.serial.SerialPropertyPeer;
import nextapp.echo.app.serial.property.ExtentPeer;
import nextapp.echo.app.serial.property.ImageReferencePeer;
import nextapp.echo.app.util.ConstantMap;
import nextapp.echo.app.util.Context;
import nextapp.echo.app.util.DomUtil;
import org.w3c.dom.Element;

public class FillImagePeer
implements SerialPropertyPeer {
    private static final ConstantMap REPEAT_CONSTANTS = new ConstantMap();

    public Element toElement(Context context, FillImage fillImage) throws SerialException {
        Extent offsetY;
        SerialContext serialContext = (SerialContext)context.get(SerialContext.class);
        Element fiElement = serialContext.getDocument().createElement("fi");
        ImageReference imageReference = fillImage.getImage();
        PropertyPeerFactory propertyPeerFactory = (PropertyPeerFactory)context.get(PropertyPeerFactory.class);
        SerialPropertyPeer propertyPeer = propertyPeerFactory.getPeerForProperty(imageReference.getClass());
        if (propertyPeer == null) {
            throw new IllegalArgumentException("Image peer not found for container image");
        }
        if (!(propertyPeer instanceof ImageReferencePeer)) {
            throw new IllegalArgumentException("Property peer for contained image is not an ImageReferencePeer");
        }
        ImageReferencePeer imagePeer = (ImageReferencePeer)propertyPeer;
        fiElement.setAttribute("u", imagePeer.getImageUrl(context, imageReference));
        Extent offsetX = fillImage.getHorizontalOffset();
        if (offsetX != null) {
            fiElement.setAttribute("x", ExtentPeer.toString(offsetX));
        }
        if ((offsetY = fillImage.getVerticalOffset()) != null) {
            fiElement.setAttribute("y", ExtentPeer.toString(offsetY));
        }
        fiElement.setAttribute("r", REPEAT_CONSTANTS.get(fillImage.getRepeat()));
        return fiElement;
    }

    public FillImage fromElement(Context context, Element fiElement) throws SerialException {
        String imageType = fiElement.getAttribute("t");
        PropertyPeerFactory propertyPeerFactory = (PropertyPeerFactory)context.get(PropertyPeerFactory.class);
        SerialPropertyPeer imagePropertyPeer = null;
        if ("r".equals(imageType)) {
            imagePropertyPeer = propertyPeerFactory.getPeerForProperty(ResourceImageReference.class);
        } else if ("h".equals(imageType)) {
            imagePropertyPeer = propertyPeerFactory.getPeerForProperty(HttpImageReference.class);
        } else if (imageType != null) {
            SerialContext serialContext = (SerialContext)context.get(SerialContext.class);
            try {
                imagePropertyPeer = propertyPeerFactory.getPeerForProperty(serialContext.getClassLoader().loadClass(imageType));
            }
            catch (ClassNotFoundException ex) {
                throw new SerialException("Object class not found.", ex);
            }
        } else {
            throw new RuntimeException("No image type specified");
        }
        if (imagePropertyPeer == null) {
            throw new RuntimeException("Unknown image type: " + imageType);
        }
        ImageReference imageReference = (ImageReference)imagePropertyPeer.toProperty(context, FillImage.class, fiElement);
        int repeat = REPEAT_CONSTANTS.get(fiElement.getAttribute("r"), 3);
        Extent x = fiElement.hasAttribute("x") ? ExtentPeer.fromString(fiElement.getAttribute("x")) : null;
        Extent y = fiElement.hasAttribute("y") ? ExtentPeer.fromString(fiElement.getAttribute("y")) : null;
        return new FillImage(imageReference, x, y, repeat);
    }

    public Object toProperty(Context context, Class objectClass, Element propertyElement) throws SerialException {
        Element fiElement = DomUtil.getChildElementByTagName(propertyElement, "fi");
        return this.fromElement(context, fiElement);
    }

    public void toXml(Context context, Class objectClass, Element propertyElement, Object propertyValue) throws SerialException {
        SerialContext serialContext = (SerialContext)context.get(SerialContext.class);
        FillImage fillImage = (FillImage)propertyValue;
        propertyElement.setAttribute("t", (serialContext.getFlags() & 1) == 0 ? "FillImage" : "FI");
        propertyElement.appendChild(this.toElement(context, fillImage));
    }

    static {
        REPEAT_CONSTANTS.add(0, "0");
        REPEAT_CONSTANTS.add(1, "x");
        REPEAT_CONSTANTS.add(2, "y");
        REPEAT_CONSTANTS.add(3, "xy");
    }
}

