/*
 * Decompiled with CFR 0.152.
 */
package nextapp.echo.app.util;

import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import nextapp.echo.app.util.PropertiesDiscovery;

public class PeerFactory {
    private final Map objectClassNameToPeerMap = new HashMap();

    public PeerFactory(String resourceName, ClassLoader classLoader) {
        try {
            Map peerNameMap = PropertiesDiscovery.loadProperties(resourceName, classLoader);
            Iterator it = peerNameMap.keySet().iterator();
            while (it.hasNext()) {
                String objectClassName = ((String)it.next()).trim();
                String peerClassName = ((String)peerNameMap.get(objectClassName)).trim();
                Class<?> peerClass = classLoader.loadClass(peerClassName);
                Object peer = peerClass.newInstance();
                this.objectClassNameToPeerMap.put(objectClassName, peer);
            }
        }
        catch (ClassNotFoundException ex) {
            throw new RuntimeException("Unable to load synchronize peer bindings.", ex);
        }
        catch (IOException ex) {
            throw new RuntimeException("Unable to load synchronize peer bindings.", ex);
        }
        catch (InstantiationException ex) {
            throw new RuntimeException("Unable to load synchronize peer bindings.", ex);
        }
        catch (IllegalAccessException ex) {
            throw new RuntimeException("Unable to load synchronize peer bindings.", ex);
        }
    }

    public Object getPeerForObject(Class objectClass, boolean searchSuperClasses) {
        Object peer = null;
        do {
            if ((peer = (Object)this.objectClassNameToPeerMap.get(objectClass.getName())) != null) {
                return peer;
            }
            if (!searchSuperClasses) continue;
            Class<?>[] interfaces = objectClass.getInterfaces();
            for (int i = 0; i < interfaces.length; ++i) {
                peer = this.getPeerForObject(interfaces[i], true);
                if (peer == null) continue;
                return peer;
            }
            objectClass = objectClass.getSuperclass();
        } while (searchSuperClasses && objectClass != null);
        return null;
    }
}

