/*
 * Decompiled with CFR 0.152.
 */
package nextapp.echo.app;

import nextapp.echo.app.Component;
import nextapp.echo.app.Extent;
import nextapp.echo.app.FillImage;
import nextapp.echo.app.FloatingPane;
import nextapp.echo.app.Insets;
import nextapp.echo.app.Pane;
import nextapp.echo.app.PaneContainer;
import nextapp.echo.app.Window;

public class ContentPane
extends Component
implements Pane,
PaneContainer {
    private static final long serialVersionUID = 20070101L;
    private static final Extent PX_0 = new Extent(0);
    private static final Extent SCROLL_BOTTOM = new Extent(-1);
    public static final String PROPERTY_BACKGROUND_IMAGE = "backgroundImage";
    public static final String PROPERTY_HORIZONTAL_SCROLL = "horizontalScroll";
    public static final String PROPERTY_INSETS = "insets";
    public static final String PROPERTY_OVERFLOW = "overflow";
    public static final String PROPERTY_VERTICAL_SCROLL = "verticalScroll";
    public static final int OVERFLOW_AUTO = 0;
    public static final int OVERFLOW_HIDDEN = 1;
    public static final int OVERFLOW_SCROLL = 2;

    public FillImage getBackgroundImage() {
        return (FillImage)this.get(PROPERTY_BACKGROUND_IMAGE);
    }

    public Extent getHorizontalScroll() {
        return (Extent)this.get(PROPERTY_HORIZONTAL_SCROLL);
    }

    public int getOverflow() {
        Integer overflow = (Integer)this.get(PROPERTY_OVERFLOW);
        return overflow == null ? 0 : overflow;
    }

    public Insets getInsets() {
        return (Insets)this.get(PROPERTY_INSETS);
    }

    public Extent getVerticalScroll() {
        return (Extent)this.get(PROPERTY_VERTICAL_SCROLL);
    }

    public boolean isValidChild(Component child) {
        if (child instanceof FloatingPane) {
            return true;
        }
        int componentCount = this.getComponentCount();
        for (int i = 0; i < componentCount; ++i) {
            if (this.getComponent(i) instanceof FloatingPane) continue;
            return false;
        }
        return true;
    }

    public boolean isValidParent(Component parent) {
        return parent instanceof PaneContainer || parent instanceof Window;
    }

    public void processInput(String inputName, Object inputValue) {
        if (PROPERTY_HORIZONTAL_SCROLL.equals(inputName)) {
            this.setHorizontalScroll((Extent)inputValue);
        } else if (PROPERTY_VERTICAL_SCROLL.equals(inputName)) {
            this.setVerticalScroll((Extent)inputValue);
        }
    }

    public void setBackgroundImage(FillImage newValue) {
        this.set(PROPERTY_BACKGROUND_IMAGE, newValue);
    }

    public void setHorizontalScroll(Extent newValue) {
        this.set(PROPERTY_HORIZONTAL_SCROLL, newValue);
    }

    public void setInsets(Insets newValue) {
        this.set(PROPERTY_INSETS, newValue);
    }

    public void setOverflow(int newValue) {
        this.set(PROPERTY_OVERFLOW, new Integer(newValue));
    }

    public void setVerticalScroll(Extent newValue) {
        if (SCROLL_BOTTOM.equals(newValue)) {
            this.set(PROPERTY_VERTICAL_SCROLL, PX_0);
        }
        this.set(PROPERTY_VERTICAL_SCROLL, newValue);
    }
}

