/*
 * Decompiled with CFR 0.152.
 */
package nextapp.echo.app.serial.property;

import java.util.StringTokenizer;
import nextapp.echo.app.Extent;
import nextapp.echo.app.Insets;
import nextapp.echo.app.serial.SerialException;
import nextapp.echo.app.serial.SerialPropertyPeer;
import nextapp.echo.app.serial.property.ExtentPeer;
import nextapp.echo.app.util.Context;
import nextapp.echo.app.util.DomUtil;
import org.w3c.dom.Element;

public class InsetsPeer
implements SerialPropertyPeer {
    public static Insets fromString(String value) throws SerialException {
        if (value == null) {
            return null;
        }
        Extent[] extents = new Extent[4];
        value = value.trim();
        StringTokenizer st = new StringTokenizer(value, " ");
        int count = 0;
        for (int i = 0; i < extents.length && st.hasMoreTokens(); ++i) {
            extents[i] = ExtentPeer.fromString(st.nextToken());
            ++count;
        }
        switch (count) {
            case 1: {
                return new Insets(extents[0]);
            }
            case 2: {
                return new Insets(extents[1], extents[0]);
            }
            case 3: {
                return new Insets(extents[1], extents[0], extents[1], extents[2]);
            }
            case 4: {
                return new Insets(extents[3], extents[0], extents[1], extents[2]);
            }
        }
        throw new SerialException("Invalid extent string: " + value, null);
    }

    private static boolean equals(Extent extent1, Extent extent2) {
        if (extent1 == null && extent2 == null) {
            return true;
        }
        if (extent1 == null || extent2 == null) {
            return false;
        }
        return extent1.equals(extent2);
    }

    private static String toString(Extent extent) throws SerialException {
        return extent == null ? "0px" : ExtentPeer.toString(extent);
    }

    public static String toString(Insets insets) throws SerialException {
        if (InsetsPeer.equals(insets.getTop(), insets.getBottom()) && InsetsPeer.equals(insets.getLeft(), insets.getRight())) {
            if (InsetsPeer.equals(insets.getTop(), insets.getLeft())) {
                return InsetsPeer.toString(insets.getTop());
            }
            return InsetsPeer.toString(insets.getTop()) + " " + InsetsPeer.toString(insets.getLeft());
        }
        return InsetsPeer.toString(insets.getTop()) + " " + InsetsPeer.toString(insets.getRight()) + " " + InsetsPeer.toString(insets.getBottom()) + " " + InsetsPeer.toString(insets.getLeft());
    }

    public Object toProperty(Context context, Class objectClass, Element propertyElement) throws SerialException {
        return InsetsPeer.fromString(propertyElement.hasAttribute("v") ? propertyElement.getAttribute("v") : DomUtil.getElementText(propertyElement));
    }

    public void toXml(Context context, Class objectClass, Element propertyElement, Object propertyValue) throws SerialException {
        propertyElement.appendChild(propertyElement.getOwnerDocument().createTextNode(InsetsPeer.toString((Insets)propertyValue)));
    }
}

