/*
 * Decompiled with CFR 0.152.
 */
package nextapp.echo.app.serial.property;

import nextapp.echo.app.Color;
import nextapp.echo.app.serial.SerialContext;
import nextapp.echo.app.serial.SerialException;
import nextapp.echo.app.serial.SerialPropertyPeer;
import nextapp.echo.app.util.Context;
import nextapp.echo.app.util.DomUtil;
import org.w3c.dom.Element;

public class ColorPeer
implements SerialPropertyPeer {
    private static final String COLOR_MASK = "#000000";

    public static final Color fromString(String value) throws SerialException {
        try {
            int colorValue = Integer.parseInt(value.trim().substring(1), 16);
            return new Color(colorValue);
        }
        catch (IndexOutOfBoundsException ex) {
            throw new SerialException("Invalid color value: " + value, ex);
        }
        catch (NumberFormatException ex) {
            throw new SerialException("Invalid color value: " + value, ex);
        }
    }

    public static final String toString(Color color) throws SerialException {
        int rgb = color.getRgb();
        String colorString = Integer.toString(rgb, 16);
        return COLOR_MASK.substring(0, 7 - colorString.length()) + colorString;
    }

    public Object toProperty(Context context, Class objectClass, Element propertyElement) throws SerialException {
        return ColorPeer.fromString(DomUtil.getElementText(propertyElement));
    }

    public void toXml(Context context, Class objectClass, Element propertyElement, Object propertyValue) throws SerialException {
        SerialContext serialContext = (SerialContext)context.get(SerialContext.class);
        propertyElement.appendChild(serialContext.getDocument().createTextNode(ColorPeer.toString((Color)propertyValue)));
    }
}

