/*
 * Decompiled with CFR 0.152.
 */
package nextapp.echo.app.serial;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import nextapp.echo.app.DerivedMutableStyle;
import nextapp.echo.app.MutableStyleSheet;
import nextapp.echo.app.Style;
import nextapp.echo.app.StyleSheet;
import nextapp.echo.app.serial.SerialContext;
import nextapp.echo.app.serial.SerialException;
import nextapp.echo.app.serial.Serializer;
import nextapp.echo.app.util.DomUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

public class StyleSheetLoader {
    static /* synthetic */ Class class$java$lang$Object;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static StyleSheet load(String resourceName, ClassLoader classLoader) throws SerialException {
        InputStream in = null;
        in = classLoader.getResourceAsStream(resourceName);
        if (in == null) {
            StyleSheet styleSheet = null;
            return styleSheet;
        }
        StyleSheet styleSheet = StyleSheetLoader.load(in, classLoader);
        return styleSheet;
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException ex) {}
            }
        }
    }

    public static StyleSheet load(InputStream in, final ClassLoader classLoader) throws SerialException {
        Class<?> componentClass;
        String type;
        String name;
        int i;
        Document document;
        try {
            DocumentBuilder builder = DomUtil.getDocumentBuilder();
            document = builder.parse(in);
        }
        catch (IOException ex) {
            throw new SerialException("Failed to parse InputStream.", ex);
        }
        catch (SAXException ex) {
            throw new SerialException("Failed to parse InputStream.", ex);
        }
        HashMap namedStyleMap = new HashMap();
        MutableStyleSheet styleSheet = new MutableStyleSheet();
        Element styleSheetElement = document.getDocumentElement();
        Element[] styleElements = DomUtil.getChildElementsByTagName(styleSheetElement, "s");
        Serializer serializer = Serializer.forClassLoader(classLoader);
        for (i = 0; i < styleElements.length; ++i) {
            name = styleElements[i].getAttribute("n");
            if ("".equals(name)) {
                name = null;
            }
            if (!styleElements[i].hasAttribute("t")) {
                throw new SerialException("Component type not specified in style: " + name, null);
            }
            type = styleElements[i].getAttribute("t");
            try {
                componentClass = serializer.getClass(type);
            }
            catch (ClassNotFoundException ex) {
                continue;
            }
            DerivedMutableStyle style = new DerivedMutableStyle();
            SerialContext context = new SerialContext(){

                public ClassLoader getClassLoader() {
                    return classLoader;
                }

                public int getFlags() {
                    return 0;
                }

                public Document getDocument() {
                    return document;
                }
            };
            Style propertyStyle = serializer.loadStyle(context, type, styleElements[i]);
            style.addStyleContent(propertyStyle);
            HashMap classToStyleMap = (HashMap)namedStyleMap.get(name);
            if (classToStyleMap == null) {
                classToStyleMap = new HashMap();
                namedStyleMap.put(name, classToStyleMap);
            }
            classToStyleMap.put(componentClass, style);
            styleSheet.addStyle(componentClass, name, style);
        }
        for (i = 0; i < styleElements.length; ++i) {
            if (!styleElements[i].hasAttribute("b")) continue;
            name = styleElements[i].getAttribute("n");
            type = styleElements[i].getAttribute("t");
            try {
            }
            catch (ClassNotFoundException ex) {
                continue;
            }
            Map classToStyleMap = (Map)namedStyleMap.get(name);
            DerivedMutableStyle style = (DerivedMutableStyle)classToStyleMap.get(componentClass);
            String baseName = styleElements[i].getAttribute("b");
            classToStyleMap = (Map)namedStyleMap.get(baseName);
            if (classToStyleMap == null) {
                throw new SerialException("Invalid base style name for style name " + name + ".", null);
            }
            Style baseStyle = (Style)classToStyleMap.get(componentClass);
            for (componentClass = Class.forName(type, true, classLoader); baseStyle == null && componentClass != (class$java$lang$Object == null ? StyleSheetLoader.class$("java.lang.Object") : class$java$lang$Object); componentClass = componentClass.getSuperclass()) {
                baseStyle = (Style)classToStyleMap.get(componentClass);
            }
            if (baseStyle == null) {
                throw new SerialException("Invalid base style name for style name " + name + ".", null);
            }
            style.setParentStyle(baseStyle);
        }
        return styleSheet;
    }
}

