/*
 * Decompiled with CFR 0.152.
 */
package com.nexmo.sdk.conversation.push;

import com.nexmo.sdk.conversation.client.Member;
import com.nexmo.sdk.conversation.core.util.DateUtil;
import java.text.ParseException;
import java.util.Date;
import org.json.JSONException;
import org.json.JSONObject;

public class InviteEvent {
    public static final String MESSAGE_KEY_INVITE = "invited";
    private static final String MESSAGE_KEY_USER = "user";
    private static final String MESSAGE_KEY_USERNAME = "name";
    private static final String MESSAGE_KEY_STATE = "state";
    private static final String MESSAGE_KEY_CNAME = "cname";
    private static final String MESSAGE_KEY_INVITE_BY = "invited_by";
    private static final String MESSAGE_KEY_TIMESTAMP = "timestamp";
    String senderMemberId;
    String cName;
    String conversationId;
    String senderUsername;
    JSONObject time;
    Date timestampInvited;
    Member invitedMember;

    public String getSenderMemberId() {
        return this.senderMemberId;
    }

    public String getcName() {
        return this.cName;
    }

    public String getConversationId() {
        return this.conversationId;
    }

    public String getSenderUsername() {
        return this.senderUsername;
    }

    public JSONObject getTime() {
        return this.time;
    }

    public Date getTimestampInvited() {
        return this.timestampInvited;
    }

    public Member getInvitedMember() {
        return this.invitedMember;
    }

    private InviteEvent(String senderMemberId, String cName, String senderUsername, JSONObject time, Date timestampInvited, Member invitedMember, String conversationId) {
        this.senderMemberId = senderMemberId;
        this.cName = cName;
        this.senderUsername = senderUsername;
        this.time = time;
        this.timestampInvited = timestampInvited;
        this.invitedMember = invitedMember;
        this.conversationId = conversationId;
    }

    public static InviteEvent createInviteEvent(JSONObject body, String senderId, String conversationId) throws JSONException {
        JSONObject time = body.getJSONObject(MESSAGE_KEY_TIMESTAMP);
        Date timestampInvited = null;
        try {
            timestampInvited = DateUtil.formatIso8601DateString(time.getString(MESSAGE_KEY_INVITE));
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        JSONObject user = body.getJSONObject(MESSAGE_KEY_USER);
        user.put(MESSAGE_KEY_USERNAME, (Object)user.getString(MESSAGE_KEY_USERNAME));
        user.put(MESSAGE_KEY_STATE, (Object)Member.STATE.INVITED.getId());
        user.put(MESSAGE_KEY_TIMESTAMP, (Object)time);
        user.put(MESSAGE_KEY_INVITE, (Object)timestampInvited);
        Member invitedMember = Member.fromJson(user);
        InviteEvent inviteEvent = new InviteEvent(senderId, body.getString(MESSAGE_KEY_CNAME), body.getString(MESSAGE_KEY_INVITE_BY), time, timestampInvited, invitedMember, conversationId);
        return inviteEvent;
    }
}

