/*
 * Decompiled with CFR 0.152.
 */
package com.nexmo.sdk.conversation.push;

import com.nexmo.sdk.conversation.client.Image;
import com.nexmo.sdk.conversation.core.util.Log;
import com.nexmo.sdk.conversation.push.ConversationMessagingService;
import org.json.JSONException;
import org.json.JSONObject;

public class ImageEvent {
    String conversationId;
    Image incomingImage;

    public String getConversationId() {
        return this.conversationId;
    }

    public Image getIncomingImage() {
        return this.incomingImage;
    }

    private ImageEvent(Image incomingImage, String conversationId) {
        this.incomingImage = incomingImage;
        this.conversationId = conversationId;
    }

    public static ImageEvent createImageEvent(String senderId, String eventId, JSONObject body, String conversationId) throws JSONException {
        Image incomingImage = Image.fromPush(senderId, eventId, body);
        Log.d(ConversationMessagingService.TAG, "new image" + incomingImage.toString());
        return new ImageEvent(incomingImage, conversationId);
    }

    public static ImageEvent createImageEventFromBundle(String conversationId, Image image) {
        return new ImageEvent(image, conversationId);
    }
}

