/*
 * Decompiled with CFR 0.152.
 */
package com.nexmo.sdk.conversation.push;

import android.content.Intent;
import android.os.Bundle;
import android.os.Parcelable;
import com.nexmo.sdk.conversation.client.Image;
import com.nexmo.sdk.conversation.client.Member;
import com.nexmo.sdk.conversation.client.Text;
import com.nexmo.sdk.conversation.core.util.Log;
import com.nexmo.sdk.conversation.push.ConversationMessagingService;
import com.nexmo.sdk.conversation.push.EventExtractor;
import com.nexmo.sdk.conversation.push.ImageEvent;
import com.nexmo.sdk.conversation.push.InviteEvent;
import com.nexmo.sdk.conversation.push.TextEvent;
import org.json.JSONException;
import org.json.JSONObject;

class HandleFirebaseMessage {
    private static final String MESSAGE_TYPE_TEXT = "text";
    private static final String MESSAGE_TYPE_IMAGE = "image";
    private static final String MESSAGE_TYPE_INVITE = "member:invited";

    HandleFirebaseMessage() {
    }

    public Intent invoke(JSONObject eventJson) {
        Intent intent = new Intent("com.nexmo.sdk.conversation.PUSH");
        try {
            EventExtractor eventExtractor = new EventExtractor(eventJson).fromJson();
            switch (eventExtractor.getType()) {
                case "text": {
                    intent = this.textEventBundleIntent(intent, eventExtractor);
                    break;
                }
                case "image": {
                    intent = this.imageEventBundleIntent(intent, eventExtractor);
                    break;
                }
                case "member:invited": {
                    intent = this.inviteEventBundleEvent(intent, eventExtractor);
                    break;
                }
                default: {
                    Log.d(ConversationMessagingService.TAG, "incoming event of unrecognized type - " + eventExtractor.getType());
                    return null;
                }
            }
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        return intent;
    }

    Intent textEventBundleIntent(Intent intent, EventExtractor eventExtractor) throws JSONException {
        Log.d(ConversationMessagingService.TAG, "incoming TEXT");
        TextEvent textEvent = TextEvent.createTextEvent(eventExtractor.getSenderId(), eventExtractor.getEventId(), eventExtractor.getJsonBody(), eventExtractor.getCid());
        Bundle bundle = new Bundle();
        bundle.putString("conversation.sdk.type", "conversation.sdk.push.text");
        bundle.putParcelable(Text.class.getSimpleName(), (Parcelable)textEvent.text);
        bundle.putString("conversation.sdk.conversation:id", textEvent.getConversationId());
        intent = intent.putExtras(bundle);
        return intent;
    }

    Intent imageEventBundleIntent(Intent intent, EventExtractor eventExtractor) throws JSONException {
        Log.d(ConversationMessagingService.TAG, "incoming IMAGE");
        ImageEvent imageEvent = ImageEvent.createImageEvent(eventExtractor.getSenderId(), eventExtractor.getEventId(), eventExtractor.getJsonBody(), eventExtractor.getCid());
        Bundle bundle = new Bundle();
        bundle.putString("conversation.sdk.type", "conversation.sdk.push.image");
        bundle.putParcelable(Image.class.getSimpleName(), (Parcelable)imageEvent.incomingImage);
        bundle.putString("conversation.sdk.conversation:id", imageEvent.getConversationId());
        intent = intent.putExtras(bundle);
        return intent;
    }

    Intent inviteEventBundleEvent(Intent intent, EventExtractor eventExtractor) throws JSONException {
        Log.d(ConversationMessagingService.TAG, "incoming Invite");
        InviteEvent inviteEvent = InviteEvent.createInviteEvent(eventExtractor.getBody(), eventExtractor.getSenderId(), eventExtractor.getCid());
        Bundle bundle = new Bundle();
        Log.d(ConversationMessagingService.TAG, "invited cid: " + inviteEvent.conversationId + " .cname: " + inviteEvent.cName + " .senderMemberId: " + inviteEvent.senderMemberId + " .senderUsername: " + inviteEvent.senderUsername);
        bundle.putString("conversation.sdk.type", "conversation.sdk.push.member:invited");
        bundle.putParcelable(Member.class.getSimpleName(), (Parcelable)inviteEvent.invitedMember);
        bundle.putString("conversation.sdk.push.member:invitedBy:memberId", inviteEvent.senderMemberId);
        bundle.putString("conversation.sdk.push.member:invitedBy:username", inviteEvent.senderUsername);
        bundle.putString("conversation.sdk.push.member:invited:conversation:id", inviteEvent.conversationId);
        bundle.putString("conversation.sdk.push.member:invited:conversation:name", inviteEvent.cName);
        intent = intent.putExtras(bundle);
        return intent;
    }
}

