/*
 * Decompiled with CFR 0.152.
 */
package com.nexmo.sdk.conversation.push;

import com.google.firebase.messaging.FirebaseMessagingService;
import com.google.firebase.messaging.RemoteMessage;
import com.nexmo.sdk.conversation.core.util.Log;
import com.nexmo.sdk.conversation.push.HandleFirebaseMessage;
import java.util.Map;
import org.json.JSONException;
import org.json.JSONObject;

public class ConversationMessagingService
extends FirebaseMessagingService {
    public static final String TAG = ConversationMessagingService.class.getSimpleName();
    private static final String MESSAGE_PAYLOAD_KEY = "event";

    public void onMessageReceived(RemoteMessage message) {
        Map data = message.getData();
        Log.d(TAG, "Remote message Data: " + data.toString());
        JSONObject messagePayload = this.getMessagePayload(data);
        if (messagePayload != null) {
            this.sendBroadcast(new HandleFirebaseMessage().invoke(messagePayload));
        }
    }

    JSONObject getMessagePayload(final Map data) {
        return new Object(){

            public JSONObject invoke() {
                JSONObject eventJson = null;
                if (data.containsKey(ConversationMessagingService.MESSAGE_PAYLOAD_KEY)) {
                    String eventString = (String)data.get(ConversationMessagingService.MESSAGE_PAYLOAD_KEY);
                    try {
                        eventJson = new JSONObject(eventString);
                    }
                    catch (JSONException e) {
                        e.printStackTrace();
                    }
                }
                return eventJson;
            }
        }.invoke();
    }
}

