/*
 * Decompiled with CFR 0.152.
 */
package com.nexmo.sdk.conversation.device;

import android.content.ContentResolver;
import android.content.Context;
import android.content.SharedPreferences;
import android.os.Build;
import android.provider.Settings;
import android.text.TextUtils;
import java.util.Locale;
import java.util.UUID;

public class DeviceProperties {
    private static final String TAG = DeviceProperties.class.getSimpleName();
    private static String uniqueID = null;
    private static final String PREF_UNIQUE_ID = "PREF_UNIQUE_ID";

    public static String getApiLevel() {
        return Build.VERSION.RELEASE;
    }

    public static String getAndroid_ID(Context context) {
        if (context != null) {
            return Settings.Secure.getString((ContentResolver)context.getContentResolver(), (String)"android_id");
        }
        return null;
    }

    public static String getLanguage() {
        String language = Locale.getDefault().toString();
        if (!TextUtils.isEmpty((CharSequence)language) && language.indexOf("_") > 1) {
            return language.replace("_", "-");
        }
        return null;
    }

    public static String getUserid(Context context) {
        SharedPreferences sharedPrefs;
        if (uniqueID == null && (uniqueID = (sharedPrefs = context.getSharedPreferences(PREF_UNIQUE_ID, 0)).getString(PREF_UNIQUE_ID, null)) == null) {
            uniqueID = UUID.randomUUID().toString();
            SharedPreferences.Editor editor = sharedPrefs.edit();
            editor.putString(PREF_UNIQUE_ID, uniqueID);
            editor.apply();
        }
        return uniqueID;
    }

    public static void resetUserId(Context context) {
        uniqueID = null;
        SharedPreferences sharedPrefs = context.getSharedPreferences(PREF_UNIQUE_ID, 0);
        SharedPreferences.Editor editor = sharedPrefs.edit();
        editor.remove(PREF_UNIQUE_ID);
        editor.apply();
    }
}

