/*
 * Decompiled with CFR 0.152.
 */
package com.nexmo.sdk.conversation.core.persistence.repository;

import android.database.Cursor;
import android.database.DatabaseUtils;
import android.database.sqlite.SQLiteDatabase;
import com.nexmo.sdk.conversation.client.CacheDB;
import com.nexmo.sdk.conversation.client.Member;
import com.nexmo.sdk.conversation.core.persistence.contract.MemberContract;
import com.nexmo.sdk.conversation.core.persistence.dao.MemberDAO;
import com.nexmo.sdk.conversation.core.util.Log;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class MemberRepository
implements MemberDAO {
    private static final String TAG = MemberRepository.class.getSimpleName();
    private CacheDB cacheDB;

    public MemberRepository(CacheDB cacheDB) {
        this.cacheDB = cacheDB;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void insertAll(String cid, List<Member> members) {
        Log.d(TAG, "bulkInsertMembersToConversation. cid:  " + cid + " members. " + members.toString());
        this.delete(cid);
        SQLiteDatabase db = this.cacheDB.openDatabase();
        db.beginTransaction();
        try {
            for (Member member : members) {
                db.insert("member", null, MemberContract.contentValues(member, cid));
            }
            db.setTransactionSuccessful();
        }
        finally {
            db.endTransaction();
        }
    }

    @Override
    public boolean delete(String cid) {
        Log.d(TAG, "removeMembersFromConversation. cid " + cid);
        SQLiteDatabase db = this.cacheDB.openDatabase();
        return db.delete("member", "cid = ?", new String[]{cid}) != 0;
    }

    @Override
    public boolean delete(Collection<String> ids) {
        return false;
    }

    @Override
    public void update(Member member, String cid) {
        Log.d(TAG, "updateMemberOfConversation. cid " + cid);
        SQLiteDatabase db = this.cacheDB.openDatabase();
        db.update("member", MemberContract.contentValues(member, cid), "cid = ? AND id = ?", new String[]{cid, member.getMemberId()});
    }

    @Override
    public List<Member> read(String cid) {
        Log.d(TAG, "read for cid " + cid);
        ArrayList<Member> members = new ArrayList<Member>();
        SQLiteDatabase db = this.cacheDB.openDatabase();
        if (DatabaseUtils.queryNumEntries((SQLiteDatabase)db, (String)"member") == 0L) {
            return null;
        }
        String[] projection = new String[]{"cid", "id", "username", "user_id", "state", "invited_at", "joined_at", "left_at"};
        String[] selectionArgs = new String[]{String.valueOf(cid)};
        Cursor cursor = db.query("member", projection, "cid = ?", selectionArgs, null, null, null);
        if (cursor != null) {
            cursor.moveToFirst();
            while (!cursor.isAfterLast()) {
                Member member = Member.fromCursor(cursor);
                members.add(member);
                cursor.moveToNext();
            }
            cursor.close();
        }
        Log.d(TAG, "getMembers: " + ((Object)members).toString());
        return members;
    }

    @Override
    public void insert(Member member, String cid) {
        Log.d(TAG, "insert.cid " + cid);
        SQLiteDatabase db = this.cacheDB.openDatabase();
        long pk = db.insertWithOnConflict("member", null, MemberContract.contentValues(member, cid), 5);
    }
}

