/*
 * Decompiled with CFR 0.152.
 */
package com.nexmo.sdk.conversation.core.persistence.repository;

import android.database.Cursor;
import android.database.DatabaseUtils;
import android.database.sqlite.SQLiteDatabase;
import android.text.TextUtils;
import com.nexmo.sdk.conversation.client.CacheDB;
import com.nexmo.sdk.conversation.client.Conversation;
import com.nexmo.sdk.conversation.client.Event;
import com.nexmo.sdk.conversation.core.persistence.contract.EventContract;
import com.nexmo.sdk.conversation.core.persistence.dao.EventDAO;
import com.nexmo.sdk.conversation.core.util.Log;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

public class EventRepository
implements EventDAO {
    private static final String TAG = EventRepository.class.getSimpleName();
    private CacheDB cacheDB;

    public EventRepository(CacheDB cacheDB) {
        this.cacheDB = cacheDB;
    }

    @Override
    public void insert(Event event, String cid) {
        Log.d(TAG, "insertAll ID: " + event.getId());
        SQLiteDatabase db = this.cacheDB.openDatabase();
        long pk = db.insertWithOnConflict("message", null, EventContract.contentValues(event, cid), 5);
    }

    @Override
    public void update(Event event, String cid) {
        Log.d(TAG, "update of eventId: " + event.getId());
        SQLiteDatabase db = this.cacheDB.openDatabase();
        db.update("message", EventContract.contentValues(event, cid), "conversation_id = ? AND event_id = ?", new String[]{cid, event.getId()});
    }

    @Override
    public boolean delete(String id) {
        return false;
    }

    @Override
    public boolean delete(Collection<String> ids) {
        SQLiteDatabase db = this.cacheDB.openDatabase();
        String placeholders = TextUtils.join((CharSequence)",", Collections.nCopies(ids.size(), "?"));
        return db.delete("message", "event_id IN (" + placeholders + ") ", ids.toArray(new String[0])) != 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void insertAll(String cid, List<Event> eventList) {
        SQLiteDatabase db = this.cacheDB.openDatabase();
        db.beginTransaction();
        int rowsInserted = 0;
        try {
            for (Event event : eventList) {
                long _id = db.insert("message", null, EventContract.contentValues(event, cid));
                if (_id == -1L) continue;
                ++rowsInserted;
            }
            db.setTransactionSuccessful();
        }
        finally {
            db.endTransaction();
        }
        Log.d(TAG, "insertAll: # of messages persisted: " + rowsInserted);
    }

    @Override
    public List<Event> read(String cid, Conversation conversation) {
        ArrayList<Event> eventList = new ArrayList<Event>();
        SQLiteDatabase db = this.cacheDB.openDatabase();
        long count = DatabaseUtils.queryNumEntries((SQLiteDatabase)db, (String)"message", (String)"conversation_id = ?", (String[])new String[]{cid});
        if (count == 0L) {
            return eventList;
        }
        String[] projection = new String[]{"id", "username", "user_id", "state", "invited_at", "joined_at", "left_at", "message_type", "timestamp", "deleted_timestamp", "event_id", "delivered_receipts", "seen_receipts", "text", "image_representations", "audio_enabled"};
        String[] selectionArgs = new String[]{String.valueOf(cid)};
        Cursor cursor = db.query("message , member", projection, "conversation_id = ? AND id=member_id", selectionArgs, null, null, null);
        if (cursor != null) {
            cursor.moveToFirst();
            while (!cursor.isAfterLast()) {
                Event event = Event.fromCursor(cursor, conversation);
                eventList.add(event);
                cursor.moveToNext();
            }
            cursor.close();
        }
        Log.d(TAG, "queryConversationMessages: " + eventList.size());
        return eventList;
    }

    @Override
    public boolean isAny(String cid) {
        SQLiteDatabase db = this.cacheDB.openDatabase();
        long count = DatabaseUtils.queryNumEntries((SQLiteDatabase)db, (String)"message", (String)"conversation_id = ?", (String[])new String[]{cid});
        Log.d(TAG, "Number of persisted Events for Conversation: " + count);
        return count > 0L;
    }

    @Override
    public String getLastEventId(String cid) {
        SQLiteDatabase db = this.cacheDB.openDatabase();
        String[] projection = new String[]{" MAX(event_id) as LastEventID"};
        String lastEventId = null;
        String[] selectionArgs = new String[]{String.valueOf(cid)};
        Cursor cursor = db.query("message", projection, "conversation_id = ?", selectionArgs, null, null, null);
        if (cursor != null) {
            cursor.moveToFirst();
            lastEventId = cursor.getString(cursor.getColumnIndex("LastEventID"));
            Log.d(TAG, "Last Event ID: " + lastEventId);
            cursor.close();
        }
        return lastEventId;
    }

    @Override
    public List<String> getEventIds(Conversation conversation) {
        SQLiteDatabase db = this.cacheDB.openDatabase();
        ArrayList<String> cachedMessageIds = new ArrayList<String>();
        String[] projection = new String[]{"event_id"};
        String[] selectionArgs = new String[]{String.valueOf(conversation.getConversationId())};
        Cursor cursor = db.query("message", projection, "conversation_id = ?", selectionArgs, null, null, null);
        if (cursor != null) {
            cursor.moveToFirst();
            while (!cursor.isAfterLast()) {
                cachedMessageIds.add(cursor.getString(cursor.getColumnIndex("event_id")));
                cursor.moveToNext();
            }
            Log.d(TAG, "Conversation: " + conversation.getDisplayName() + " - Number of messages in DB: " + cursor.getCount());
            cursor.close();
        }
        Collections.sort(cachedMessageIds, new Comparator<String>(){

            @Override
            public int compare(String a, String b) {
                return Integer.parseInt(a) - Integer.parseInt(b);
            }
        });
        return cachedMessageIds;
    }
}

