/*
 * Decompiled with CFR 0.152.
 */
package com.nexmo.sdk.conversation.core.persistence.repository;

import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;
import android.text.TextUtils;
import com.nexmo.sdk.conversation.client.CacheDB;
import com.nexmo.sdk.conversation.client.Conversation;
import com.nexmo.sdk.conversation.client.User;
import com.nexmo.sdk.conversation.core.persistence.contract.ConversationContract;
import com.nexmo.sdk.conversation.core.persistence.contract.MemberContract;
import com.nexmo.sdk.conversation.core.persistence.dao.ConversationDAO;
import com.nexmo.sdk.conversation.core.util.Log;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ConversationRepository
implements ConversationDAO {
    private static final String TAG = ConversationRepository.class.getSimpleName();
    private CacheDB cacheDB;

    public ConversationRepository(CacheDB cacheDB) {
        this.cacheDB = cacheDB;
    }

    @Override
    public Conversation read(String cid) {
        SQLiteDatabase db = this.cacheDB.openDatabase();
        Conversation conversation = null;
        String[] projection = new String[]{"name", "conversation.cid", "lastEventId", "selfMemberId", "created", "id", "member.cid", "user_id", "username", "state", "invited_at", "joined_at", "left_at"};
        String[] selectionArgs = new String[]{String.valueOf(cid)};
        Cursor cursor = db.query("conversation,member", projection, "conversation.cid = ? AND conversation.cid = member.cid", selectionArgs, null, null, null);
        if (cursor != null) {
            if (cursor.moveToFirst()) {
                conversation = Conversation.fromCursor(cursor);
            }
            cursor.close();
        }
        return conversation;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void insertAll(List<Conversation> conversationList) {
        Log.d(TAG, "insertAll");
        SQLiteDatabase db = this.cacheDB.openDatabase();
        db.beginTransaction();
        try {
            for (Conversation conversation : conversationList) {
                db.insert("conversation", null, ConversationContract.contentValues(conversation));
                db.insert("member", null, MemberContract.contentValues(conversation.getSelf(), conversation.getConversationId()));
            }
            db.setTransactionSuccessful();
        }
        finally {
            db.endTransaction();
        }
    }

    @Override
    public void insert(Conversation conversation, String cid) {
        Log.d(TAG, "insertAll");
        SQLiteDatabase db = this.cacheDB.openDatabase();
        long pk = db.insertWithOnConflict("conversation", null, ConversationContract.contentValues(conversation), 5);
        db.insert("member", null, MemberContract.contentValues(conversation.getSelf(), cid));
    }

    @Override
    public boolean delete(String cid) {
        return this.delete(Collections.singletonList(cid));
    }

    @Override
    public boolean delete(Collection<String> cIds) {
        Log.d(TAG, "delete .cids " + cIds.toString());
        SQLiteDatabase db = this.cacheDB.openDatabase();
        String placeholders = TextUtils.join((CharSequence)",", Collections.nCopies(cIds.size(), "?"));
        return db.delete("conversation", "cid IN (" + placeholders + ") ", cIds.toArray(new String[0])) != 0;
    }

    @Override
    public void update(Conversation conversation, String cid) {
        Log.d(TAG, "update. cid " + conversation.getConversationId());
        SQLiteDatabase db = this.cacheDB.openDatabase();
        db.update("conversation", ConversationContract.contentValues(conversation), "cid = ? ", new String[]{cid});
    }

    @Override
    public List<Conversation> read(User self) {
        SQLiteDatabase db = this.cacheDB.openDatabase();
        ArrayList<Conversation> cachedConversations = new ArrayList<Conversation>();
        String[] projection = new String[]{"name", "conversation.cid", "lastEventId", "selfMemberId", "created", "id", "member.cid", "user_id", "username", "state", "invited_at", "joined_at", "left_at"};
        String[] selectionArgs = new String[]{String.valueOf(self.getUserId())};
        Cursor cursor = db.query("conversation,member", projection, "user_id = ? AND conversation.cid = member.cid", selectionArgs, null, null, null);
        if (cursor != null) {
            cursor.moveToFirst();
            while (!cursor.isAfterLast()) {
                Conversation conversation = Conversation.fromCursor(cursor);
                cachedConversations.add(conversation);
                cursor.moveToNext();
            }
            cursor.close();
        }
        return cachedConversations;
    }

    @Override
    public Map<String, Conversation> getConversationsListAsMap(User self) {
        HashMap<String, Conversation> cachedConversations = new HashMap<String, Conversation>();
        List<Conversation> conversations = this.read(self);
        for (Conversation conversation : conversations) {
            cachedConversations.put(conversation.getConversationId(), conversation);
        }
        return cachedConversations;
    }
}

