/*
 * Decompiled with CFR 0.152.
 */
package com.nexmo.sdk.conversation.core.persistence.contract;

import android.content.ContentValues;
import android.provider.BaseColumns;
import com.nexmo.sdk.conversation.client.Member;
import com.nexmo.sdk.conversation.core.util.DateUtil;

public final class MemberContract {
    public static ContentValues contentValues(Member member, String cid) {
        ContentValues values = new ContentValues();
        values.put("id", member.getMemberId());
        values.put("username", member.getName());
        values.put("user_id", member.getUserId());
        values.put("state", member.getState().getId());
        values.put("invited_at", DateUtil.formatIso8601DateString(member.getInvitedAt()));
        values.put("joined_at", DateUtil.formatIso8601DateString(member.getJoinedAt()));
        values.put("left_at", DateUtil.formatIso8601DateString(member.getLeftAt()));
        values.put("cid", cid);
        return values;
    }

    public static abstract class MemberEntry
    implements BaseColumns {
        public static final String TABLE_NAME = "member";
        public static final String COLUMN_MEMBER_ID = "id";
        public static final String COLUMN_USERNAME = "username";
        public static final String COLUMN_USER_ID = "user_id";
        public static final String COLUMN_STATE = "state";
        public static final String COLUMN_INVITEDAT = "invited_at";
        public static final String COLUMN_JOINEDAT = "joined_at";
        public static final String COLUMN_LEFTAT = "left_at";
    }
}

