/*
 * Decompiled with CFR 0.152.
 */
package com.nexmo.sdk.conversation.core.persistence.contract;

import android.content.ContentValues;
import android.provider.BaseColumns;
import com.nexmo.sdk.conversation.client.Event;
import com.nexmo.sdk.conversation.client.Image;
import com.nexmo.sdk.conversation.client.MemberMedia;
import com.nexmo.sdk.conversation.client.ReceiptRecordUtil;
import com.nexmo.sdk.conversation.client.Text;
import com.nexmo.sdk.conversation.core.util.DateUtil;
import org.json.JSONException;
import org.json.JSONObject;

public final class EventContract {
    private EventContract() {
        throw new AssertionError();
    }

    public static ContentValues contentValues(Event event, String cid) {
        ContentValues values = new ContentValues();
        values.put("conversation_id", cid);
        values.put("event_id", event.getId());
        values.put("member_id", event.getMember().getMemberId());
        values.put("timestamp", DateUtil.formatIso8601DateString(event.getTimestamp()));
        values.put("deleted_timestamp", event.getDeletedTimestamp() != null ? DateUtil.formatIso8601DateString(event.getDeletedTimestamp()) : null);
        if (!event.getDeliveredReceipts().isEmpty()) {
            try {
                values.put("delivered_receipts", ReceiptRecordUtil.deliveredReceiptsToJson(event).toString());
            }
            catch (JSONException e) {
                e.printStackTrace();
            }
        }
        if (!event.getSeenReceipts().isEmpty()) {
            try {
                values.put("seen_receipts", ReceiptRecordUtil.seenReceiptsToJson(event).toString());
            }
            catch (JSONException e) {
                e.printStackTrace();
            }
        }
        values.put("message_type", event.getType().toString());
        switch (event.getType()) {
            case TEXT: {
                values.put("text", ((Text)event).getText());
                values.putNull("image_representations");
                break;
            }
            case IMAGE: {
                values.putNull("text");
                Image image = (Image)event;
                if (image.getOriginal() != null && image.getThumbnail() != null && image.getMedium() != null) {
                    try {
                        values.put("image_representations", EventContract.imageRepresentationsToJson(image).toString());
                    }
                    catch (JSONException e) {
                        e.printStackTrace();
                    }
                    break;
                }
                values.putNull("image_representations");
                break;
            }
            case MEMBER_MEDIA: {
                values.put("audio_enabled", Integer.valueOf(((MemberMedia)event).isAudioEnabled() ? 1 : 0));
            }
        }
        return values;
    }

    static JSONObject imageRepresentationsToJson(Image image) throws JSONException {
        JSONObject parentJson = new JSONObject();
        JSONObject representationsJson = new JSONObject();
        representationsJson.put("original", (Object)image.getOriginal().toJSON());
        representationsJson.put("medium", (Object)image.getMedium().toJSON());
        representationsJson.put("thumbnail", (Object)image.getThumbnail().toJSON());
        parentJson.put("representations", (Object)representationsJson);
        return parentJson;
    }

    public static abstract class EventEntry
    implements BaseColumns {
        public static final String TABLE_NAME = "message";
        public static final String COLUMN_EVENT_ID = "event_id";
        public static final String COLUMN_CID = "conversation_id";
        public static final String COLUMN_MEMBER_ID = "member_id";
        public static final String COLUMN_TIMESTAMP = "timestamp";
        public static final String COLUMN_DELETED_TIMESTAMP = "deleted_timestamp";
        public static final String COLUMN_MESSAGE_TYPE = "message_type";
        public static final String COLUMN_DELIVERED_RECEIPTS = "delivered_receipts";
        public static final String COLUMN_SEEN_RECEIPTS = "seen_receipts";
        public static final String COLUMN_TEXT = "text";
        public static final String COLUMN_IMAGE_REPRESENTATIONS = "image_representations";
        public static final String COLUMN_MEMBER_MEDIA_ENABLED = "audio_enabled";
    }
}

