/*
 * Decompiled with CFR 0.152.
 */
package com.nexmo.sdk.conversation.core.persistence.contract;

import android.content.ContentValues;
import android.provider.BaseColumns;
import com.nexmo.sdk.conversation.client.Conversation;
import com.nexmo.sdk.conversation.core.util.DateUtil;

public final class ConversationContract {
    public static ContentValues contentValues(Conversation conversation) {
        ContentValues values = new ContentValues();
        values.put("cid", conversation.getConversationId());
        values.put("name", conversation.getDisplayName());
        values.put("created", DateUtil.formatIso8601DateString(conversation.getCreationDate()));
        values.put("lastEventId", conversation.getLastEventId());
        values.put("selfMemberId", conversation.getSelf().getMemberId());
        return values;
    }

    public static abstract class ConversationEntry
    implements BaseColumns {
        public static final String TABLE_NAME = "conversation";
        public static final String COLUMN_CID = "cid";
        public static final String COLUMN_NAME = "name";
        public static final String COLUMN_CREATED = "created";
        public static final String COLUMN_LAST_EVENT_ID = "lastEventId";
        public static final String COLUMN_MEMBER_ID = "selfMemberId";
    }
}

