/*
 * Decompiled with CFR 0.152.
 */
package com.nexmo.sdk.conversation.core.persistence;

import android.content.Context;
import android.graphics.Bitmap;
import android.os.Environment;
import com.nexmo.sdk.conversation.R;
import com.nexmo.sdk.conversation.client.Image;
import com.nexmo.sdk.conversation.client.ImageRepresentation;
import com.nexmo.sdk.conversation.core.util.DateUtil;
import com.nexmo.sdk.conversation.core.util.Log;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Date;

public class ImageStorage {
    private static final String TAG = ImageStorage.class.getSimpleName();

    public static String saveFileToDisk(Context context, Image image, ImageRepresentation.TYPE type) {
        Log.d(TAG, "saveFilesToDisk " + image.toString());
        String root = Environment.getExternalStorageDirectory() + "/" + context.getString(R.string.app_name) + "/Media/Images/";
        File rootFile = new File(root);
        if (!rootFile.exists() && !rootFile.mkdirs()) {
            return null;
        }
        return ImageStorage.fileGenerator(rootFile, image.getTimestamp(), image.getImageRepresentationByType(type));
    }

    private static String fileNameGenerator(Date timestamp, String id, String type) {
        return "IMG-" + DateUtil.formatImageNamingDateString(timestamp) + "-" + id + "-" + type + ".jpg";
    }

    private static String fileGenerator(File rootFile, Date imageTimestamp, ImageRepresentation imageRepresentation) {
        File imageRepresentationFile = new File(rootFile, ImageStorage.fileNameGenerator(imageTimestamp, imageRepresentation.getId(), imageRepresentation.type.toString()));
        Log.d(TAG, "saveFilesToDisk: fileGenerator " + imageRepresentationFile.getPath());
        try {
            FileOutputStream out = new FileOutputStream(imageRepresentationFile);
            imageRepresentation.getBitmap().compress(Bitmap.CompressFormat.JPEG, 90, (OutputStream)out);
            out.flush();
            out.close();
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
        return imageRepresentationFile.getPath();
    }

    public static void deleteFilesFromDisk(Context context, Image image) {
        String root = Environment.getExternalStorageDirectory() + "/" + context.getString(R.string.app_name) + "/Media/Images/";
        File rootFile = new File(root);
        if (!rootFile.exists()) {
            return;
        }
        ImageStorage.deleteFile(image.getOriginal());
        ImageStorage.deleteFile(image.getThumbnail());
        ImageStorage.deleteFile(image.getMedium());
    }

    static void deleteFile(ImageRepresentation imageRepresentation) {
        File fileToDelete = new File(imageRepresentation.getLocalFilePath());
        if (fileToDelete.exists()) {
            fileToDelete.delete();
        }
    }
}

