/*
 * Decompiled with CFR 0.152.
 */
package com.nexmo.sdk.conversation.core.networking;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import okhttp3.MediaType;
import okhttp3.RequestBody;
import okhttp3.internal.Util;
import okio.BufferedSink;
import okio.Okio;
import okio.Source;

public class InterruptableFileRequestBody
extends RequestBody {
    private static final int SEGMENT_SIZE = 2048;
    private final File file;
    private final String contentType;
    private volatile long progress = 0L;
    private volatile boolean isCanceled = false;

    public InterruptableFileRequestBody(File file, String contentType) {
        this.file = file;
        this.contentType = contentType;
    }

    public long contentLength() {
        return this.file.length();
    }

    public MediaType contentType() {
        return MediaType.parse((String)this.contentType);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeTo(BufferedSink sink) throws IOException {
        Source source = null;
        try {
            long read;
            source = Okio.source((File)this.file);
            this.progress = 0L;
            while ((read = source.read(sink.buffer(), 2048L)) != -1L) {
                if (this.isCanceled) {
                    throw new UploadCanceledByUser();
                }
                this.progress += read;
                sink.flush();
            }
        }
        finally {
            Util.closeQuietly((Closeable)source);
        }
    }

    public long getProgress() {
        return this.progress;
    }

    public boolean isFinished() {
        return this.getProgress() == this.contentLength();
    }

    public boolean isCanceled() {
        return this.isCanceled;
    }

    public synchronized void cancel() {
        this.isCanceled = true;
    }

    public static class UploadCanceledByUser
    extends IOException {
    }
}

