/*
 * Decompiled with CFR 0.152.
 */
package com.nexmo.sdk.conversation.core.networking;

import com.nexmo.sdk.conversation.core.networking.InterruptableFileRequestBody;
import com.nexmo.sdk.conversation.core.util.Log;
import java.io.File;
import java.io.IOException;
import java.util.concurrent.atomic.AtomicBoolean;
import okhttp3.Call;
import okhttp3.Callback;
import okhttp3.MultipartBody;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;

public class ImageUploader {
    private static final String TAG = ImageUploader.class.getSimpleName();

    public static CancelableCall uploadImage(String imagePath, final Callback callback, String urlIPS, String token) {
        Log.d(TAG, "uploadImage " + imagePath);
        File file = new File(imagePath);
        String fileName = file.getName();
        final AtomicBoolean inProgress = new AtomicBoolean(true);
        final InterruptableFileRequestBody fileRequestBody = new InterruptableFileRequestBody(file, "image/jpeg");
        MultipartBody requestBody = new MultipartBody.Builder().setType(MultipartBody.FORM).addFormDataPart("file", fileName, (RequestBody)fileRequestBody).addFormDataPart("quality_ratio", "100").addFormDataPart("medium_size_ratio", "50").addFormDataPart("thumbnail_size_ratio", "30").build();
        Request request = new Request.Builder().url(urlIPS).addHeader("Authorization", "Bearer " + token).post((RequestBody)requestBody).build();
        OkHttpClient okHttpClient = new OkHttpClient();
        final Call call = okHttpClient.newCall(request);
        call.enqueue(new Callback(){

            public void onFailure(Call call, IOException e) {
                inProgress.set(false);
                callback.onFailure(call, e);
            }

            public void onResponse(Call call, Response response) throws IOException {
                inProgress.set(false);
                callback.onResponse(call, response);
            }
        });
        return new CancelableCall(){

            @Override
            public void cancel() {
                call.cancel();
                fileRequestBody.cancel();
            }

            @Override
            public float progress() {
                return (float)fileRequestBody.getProgress() * 1.0f / (float)fileRequestBody.contentLength();
            }

            @Override
            public boolean inProgress() {
                return inProgress.get();
            }
        };
    }

    public static interface CancelableCall {
        public void cancel();

        public float progress();

        public boolean inProgress();
    }
}

