/*
 * Decompiled with CFR 0.152.
 */
package com.nexmo.sdk.conversation.core.client.request;

import com.nexmo.sdk.conversation.client.Image;
import com.nexmo.sdk.conversation.client.ImageRepresentation;
import com.nexmo.sdk.conversation.client.event.RequestHandler;
import com.nexmo.sdk.conversation.core.client.request.ConversationRequestBase;
import com.nexmo.sdk.conversation.core.client.request.Request;
import com.nexmo.sdk.conversation.core.client.request.SendTextMessageRequest;
import com.nexmo.sdk.conversation.core.util.DateUtil;
import java.util.Date;
import org.json.JSONException;
import org.json.JSONObject;

public class SendImageMessageRequest
extends ConversationRequestBase<RequestHandler<Image>, SendTextMessageRequest.Container> {
    public static final String IMAGE_MESSAGE = "image";
    public static final String IMAGE_MESSAGE_SUCCESS = "image:success";
    public String file;
    public String memberId;
    JSONObject imageRepresentationsObject;
    public ImageRepresentation original;
    public ImageRepresentation medium;
    public ImageRepresentation thumbnail;

    public SendImageMessageRequest(String cid, String memberId, String file, RequestHandler<Image> listener) {
        super(Request.TYPE.SEND_IMAGE, cid, listener);
        this.memberId = memberId;
        this.file = file;
    }

    public void updateImages(ImageRepresentation original, ImageRepresentation medium, ImageRepresentation thumbnail, @Deprecated JSONObject jsonObject) {
        this.original = original;
        this.medium = medium;
        this.thumbnail = thumbnail;
        this.imageRepresentationsObject = jsonObject;
    }

    @Override
    protected JSONObject makeJson() throws JSONException {
        return this.newConversationTaggedResponse().put("from", (Object)this.memberId).put("body", (Object)SendImageMessageRequest.jsonObject("representations", this.imageRepresentationsObject));
    }

    @Override
    public String getRequestName() {
        return IMAGE_MESSAGE;
    }

    @Override
    public String getSuccessEventName() {
        return IMAGE_MESSAGE_SUCCESS;
    }

    @Override
    public boolean isPersistable() {
        return true;
    }

    @Override
    public SendTextMessageRequest.Container parse(JSONObject jsonObject, JSONObject body) throws JSONException {
        String imageId = body.getString("id");
        Date timestamp = DateUtil.parseDateFromJson(body, "timestamp");
        return new SendTextMessageRequest.Container(imageId, timestamp);
    }
}

