/*
 * Decompiled with CFR 0.152.
 */
package com.nexmo.sdk.conversation.core.client.request;

import com.nexmo.sdk.conversation.client.Event;
import com.nexmo.sdk.conversation.client.Member;
import com.nexmo.sdk.conversation.client.SeenReceipt;
import com.nexmo.sdk.conversation.client.event.EventType;
import com.nexmo.sdk.conversation.client.event.RequestHandler;
import com.nexmo.sdk.conversation.core.client.request.ConversationRequestBase;
import com.nexmo.sdk.conversation.core.client.request.Request;
import com.nexmo.sdk.conversation.core.util.DateUtil;
import java.util.Date;
import org.json.JSONException;
import org.json.JSONObject;

public class SeenReceiptRequest
extends ConversationRequestBase<RequestHandler<SeenReceipt>, Container> {
    public static final String TEXT_SEEN = "text:seen";
    public static final String TEXT_SEEN_SUCCESS = "text:seen:success";
    public static final String IMAGE_SEEN = "image:seen";
    public static final String IMAGE_SEEN_SUCCESS = "image:seen:success";
    public Member member;
    public Event event;
    public EventType type;

    public SeenReceiptRequest(Event event, Member member, RequestHandler<SeenReceipt> listener) {
        super(event.getType() == EventType.TEXT ? Request.TYPE.MARK_TEXT_SEEN : Request.TYPE.MARK_IMAGE_SEEN, event.getConversation().getConversationId(), listener);
        this.event = event;
        this.member = member;
        this.type = event.getType();
    }

    @Override
    public Container parse(JSONObject jsonObject, JSONObject body) throws JSONException {
        Date timestamp = DateUtil.parseDateFromJson(body, "timestamp");
        return new Container(timestamp);
    }

    @Override
    protected JSONObject makeJson() throws JSONException {
        return this.newConversationTaggedResponse().put("from", (Object)this.member.getMemberId()).put("body", (Object)SeenReceiptRequest.jsonObject("event_id", this.event.getId()));
    }

    @Override
    public String getRequestName() {
        return this.type == EventType.TEXT ? TEXT_SEEN : IMAGE_SEEN;
    }

    @Override
    public String getSuccessEventName() {
        return this.type == EventType.TEXT ? TEXT_SEEN_SUCCESS : IMAGE_SEEN_SUCCESS;
    }

    public static class Container {
        public Date timestamp;

        public Container(Date timestamp) {
            this.timestamp = timestamp;
        }
    }
}

