/*
 * Decompiled with CFR 0.152.
 */
package com.nexmo.sdk.conversation.core.client.request;

import com.nexmo.sdk.conversation.client.event.RequestHandler;
import com.nexmo.sdk.conversation.core.client.request.ResultParser;
import java.util.UUID;
import org.json.JSONException;
import org.json.JSONObject;

public abstract class Request<T extends RequestHandler, R>
implements ResultParser<R> {
    private static final String TAG = Request.class.getSimpleName();
    public final TYPE type;
    public final String tid;
    public T listener;

    protected Request(TYPE type, String tid) {
        this.type = type;
        this.tid = tid;
    }

    protected Request(TYPE type) {
        this(type, UUID.randomUUID().toString());
    }

    protected Request(TYPE type, T listener) {
        this(type);
        this.listener = listener;
    }

    public String getTid() {
        return this.tid;
    }

    public T getListener() {
        return this.listener;
    }

    public JSONObject toJson() {
        try {
            return this.makeJson();
        }
        catch (JSONException shouldNeverHappen) {
            shouldNeverHappen.printStackTrace();
            return null;
        }
    }

    protected abstract JSONObject makeJson() throws JSONException;

    protected JSONObject newTaggedResponse() throws JSONException {
        return Request.jsonObject("tid", this.getTid());
    }

    protected static JSONObject jsonObject(String key, Object value) throws JSONException {
        return new JSONObject().put(key, value);
    }

    public abstract String getRequestName();

    public String getRequestId() {
        return this.tid;
    }

    public abstract String getSuccessEventName();

    public String toString() {
        return TAG + " .type: " + (Object)((Object)this.type) + " .tid: " + this.tid;
    }

    public boolean isPersistable() {
        return false;
    }

    public static enum TYPE {
        CREATE,
        JOIN,
        INVITE,
        LEAVE,
        GET,
        GET_EVENTS,
        SEND_TEXT,
        SEND_IMAGE,
        DELETE_EVENT,
        MARK_TEXT_SEEN,
        MARK_IMAGE_SEEN,
        MARK_TEXT_DELIVERED,
        MARK_IMAGE_DELIVERED,
        TYPING,
        PUSH_SUBSCRIBE,
        PUSH_UNSUBSCRIBE,
        GET_USER,
        RTC_NEW,
        RTC_TERMINATE,
        RTC_MUTE,
        RTC_EARMUFF,
        AUDIO_RINGING,
        OTHER;

    }
}

