/*
 * Decompiled with CFR 0.152.
 */
package com.nexmo.sdk.conversation.core.client.request;

import com.nexmo.sdk.conversation.client.Member;
import com.nexmo.sdk.conversation.client.event.RequestHandler;
import com.nexmo.sdk.conversation.core.client.request.ConversationRequestBase;
import com.nexmo.sdk.conversation.core.client.request.Request;
import com.nexmo.sdk.conversation.core.util.DateUtil;
import java.util.Date;
import org.json.JSONException;
import org.json.JSONObject;

public class LeaveRequest
extends ConversationRequestBase<RequestHandler<Void>, TimestampsContainer> {
    static final String CONVERSATION_LEAVE = "conversation:member:delete";
    static final String CONVERSATION_LEAVE_SUCCESS = "conversation:member:delete:success";
    public final Member member;

    public LeaveRequest(Request.TYPE type, String cid, Member member, RequestHandler leaveListener) {
        super(type, cid, leaveListener);
        this.member = member;
    }

    @Override
    protected JSONObject makeJson() throws JSONException {
        return this.newConversationTaggedResponse().put("body", (Object)LeaveRequest.jsonObject("member_id", this.member != null ? this.member.getMemberId() : ""));
    }

    @Override
    public String getRequestName() {
        return CONVERSATION_LEAVE;
    }

    @Override
    public String getSuccessEventName() {
        return CONVERSATION_LEAVE_SUCCESS;
    }

    @Override
    public boolean isPersistable() {
        return true;
    }

    @Override
    public TimestampsContainer parse(JSONObject jsonObject, JSONObject body) throws JSONException {
        JSONObject timestampJson = body.getJSONObject("timestamp");
        Date joinedTimestamp = null;
        Date leftTimestamp = null;
        Date invitedTimestamp = null;
        if (timestampJson.has("joined")) {
            joinedTimestamp = DateUtil.parseDateFromJson(timestampJson, "joined");
        }
        if (timestampJson.has("left")) {
            leftTimestamp = DateUtil.parseDateFromJson(timestampJson, "left");
        }
        if (timestampJson.has("invited")) {
            invitedTimestamp = DateUtil.parseDateFromJson(timestampJson, "invited");
        }
        return new TimestampsContainer(joinedTimestamp, leftTimestamp, invitedTimestamp);
    }

    public static class TimestampsContainer {
        public Date joinedTimestamp = null;
        public Date leftTimestamp = null;
        public Date invitedTimestamp = null;

        public TimestampsContainer(Date joinedTimestamp, Date leftTimestamp, Date invitedTimestamp) {
            this.joinedTimestamp = joinedTimestamp;
            this.leftTimestamp = leftTimestamp;
            this.invitedTimestamp = invitedTimestamp;
        }
    }
}

