/*
 * Decompiled with CFR 0.152.
 */
package com.nexmo.sdk.conversation.core.client.request;

import android.text.TextUtils;
import com.nexmo.sdk.conversation.client.Member;
import com.nexmo.sdk.conversation.client.event.RequestHandler;
import com.nexmo.sdk.conversation.core.client.request.ConversationRequestBase;
import com.nexmo.sdk.conversation.core.client.request.Request;
import org.json.JSONException;
import org.json.JSONObject;

public class JoinRequest
extends ConversationRequestBase<RequestHandler<Member>, Member> {
    static final String CONVERSATION_JOIN_REQUEST = "conversation:join";
    static final String CONVERSATION_JOIN_SUCCESS = "conversation:join:success";
    public String cName;
    public String memberId;
    public String userId;
    public String userName;

    private JoinRequest(String cid, String cName, RequestHandler<Member> listener, String userId, String userName) {
        super(Request.TYPE.JOIN, cid, listener);
        this.cName = cName;
        this.userId = userId;
        this.userName = userName;
    }

    private JoinRequest(String cid, String cName, String memberId, RequestHandler<Member> listener, String userId, String userName) {
        this(cid, cName, listener, userId, userName);
        this.memberId = memberId;
    }

    public static JoinRequest createJoinRequestWithUsername(String cid, String cName, RequestHandler<Member> listener, String userName) {
        return new JoinRequest(cid, cName, listener, null, userName);
    }

    public static JoinRequest createJoinRequestWithUserId(String cid, String cName, RequestHandler<Member> listener, String userId) {
        return new JoinRequest(cid, cName, listener, userId, null);
    }

    public static JoinRequest createJoinRequestWithMemberId(String cid, String cName, String memberId, RequestHandler<Member> listener, String userId, String userName) {
        return new JoinRequest(cid, cName, memberId, listener, userId, userName);
    }

    @Override
    protected JSONObject makeJson() throws JSONException {
        JSONObject bodyObj = new JSONObject();
        if (this.userId != null) {
            bodyObj.put("user_id", (Object)this.userId);
        }
        if (this.userName != null) {
            bodyObj.put("user_name", (Object)this.userName);
        }
        if (!TextUtils.isEmpty((CharSequence)this.memberId)) {
            bodyObj.put("member_id", (Object)this.memberId);
        }
        return this.newConversationTaggedResponse().put("body", (Object)bodyObj);
    }

    @Override
    public String getRequestName() {
        return CONVERSATION_JOIN_REQUEST;
    }

    @Override
    public String getSuccessEventName() {
        return CONVERSATION_JOIN_SUCCESS;
    }

    @Override
    public boolean isPersistable() {
        return true;
    }

    @Override
    public Member parse(JSONObject jsonObject, JSONObject body) throws JSONException {
        JSONObject memberJson = new JSONObject();
        memberJson.put("user_id", (Object)body.getString("user_id"));
        memberJson.put("member_id", (Object)body.getString("id"));
        memberJson.put("timestamp", (Object)body.getJSONObject("timestamp"));
        memberJson.put("state", (Object)Member.STATE.JOINED.getId());
        memberJson.put("name", (Object)this.userName);
        return Member.fromJson(memberJson);
    }
}

