/*
 * Decompiled with CFR 0.152.
 */
package com.nexmo.sdk.conversation.core.client.request;

import com.nexmo.sdk.conversation.client.Member;
import com.nexmo.sdk.conversation.client.event.RequestHandler;
import com.nexmo.sdk.conversation.core.client.request.Request;
import com.nexmo.sdk.conversation.core.client.request.ResultParser;
import com.nexmo.sdk.conversation.core.util.DateUtil;
import com.nexmo.sdk.conversation.core.util.Log;
import java.util.Date;
import org.json.JSONException;
import org.json.JSONObject;

public class InviteRequest
extends Request<RequestHandler<Member>, InviteContainer>
implements ResultParser<InviteContainer> {
    public static final String TAG = InviteRequest.class.getSimpleName();
    static final String INVITE_REQUEST = "conversation:invite";
    static final String INVITE_SUCCESS = "conversation:invite:success";
    public String cid;
    public String user;

    public InviteRequest(String cid, String user, RequestHandler<Member> listener) {
        super(Request.TYPE.INVITE, listener);
        this.cid = cid;
        this.user = user;
    }

    @Override
    protected JSONObject makeJson() throws JSONException {
        return this.newTaggedResponse().put("cid", (Object)this.cid).put("body", (Object)InviteRequest.jsonObject("user_name", this.user));
    }

    @Override
    public String getRequestName() {
        return INVITE_REQUEST;
    }

    @Override
    public String getSuccessEventName() {
        return INVITE_SUCCESS;
    }

    @Override
    public boolean isPersistable() {
        return true;
    }

    @Override
    public InviteContainer parse(JSONObject jsonObject, JSONObject body) throws JSONException {
        if (body.getString("state").equals("INVITED")) {
            String userId = body.getString("user_id");
            String memberId = body.getString("id");
            Date timestampInvited = DateUtil.parseDateFromJson(body.getJSONObject("timestamp"), "invited");
            return new InviteContainer(userId, memberId, timestampInvited);
        }
        Log.d(TAG, "onInvite:success event error, member is not INVITED");
        return null;
    }

    public static class InviteContainer {
        public String userId;
        public String memberId;
        public Date timestampInvited;

        public InviteContainer(String userId, String memberId, Date timestampInvited) {
            this.userId = userId;
            this.memberId = memberId;
            this.timestampInvited = timestampInvited;
        }
    }
}

