/*
 * Decompiled with CFR 0.152.
 */
package com.nexmo.sdk.conversation.core.client.request;

import com.nexmo.sdk.conversation.client.Conversation;
import com.nexmo.sdk.conversation.client.Member;
import com.nexmo.sdk.conversation.client.User;
import com.nexmo.sdk.conversation.client.event.RequestHandler;
import com.nexmo.sdk.conversation.core.client.request.Request;
import java.util.ArrayList;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class GetConversationsRequest
extends Request<RequestHandler<List<Conversation>>, List<Container>> {
    static final String CONVERSATIONS_GET_REQUEST = "user:conversations";
    static final String CONVERSATIONS_GET_SUCCESS = "user:conversations:success";
    private User self;

    public GetConversationsRequest(User self) {
        super(Request.TYPE.OTHER);
        this.self = self;
    }

    @Override
    protected JSONObject makeJson() throws JSONException {
        return this.newTaggedResponse();
    }

    @Override
    public String getRequestName() {
        return CONVERSATIONS_GET_REQUEST;
    }

    @Override
    public String getSuccessEventName() {
        return CONVERSATIONS_GET_SUCCESS;
    }

    @Override
    public List<Container> parse(JSONObject jsonObject, JSONObject body) throws JSONException {
        ArrayList<Container> conversationList = new ArrayList<Container>();
        JSONArray conversations = jsonObject.getJSONArray("body");
        for (int index = 0; index < conversations.length(); ++index) {
            JSONObject cBody = conversations.getJSONObject(index);
            cBody.put("user_id", (Object)this.self.getUserId());
            cBody.put("user_name", (Object)this.self.getName());
            Conversation conversation = Conversation.fromJson(cBody);
            conversationList.add(new Container(conversation, conversation.getMember(cBody.optString("member_id"))));
        }
        return conversationList;
    }

    public static class Container {
        public final Member member;
        public final Conversation conversation;

        public Container(Conversation conversation, Member member) {
            this.member = member;
            this.conversation = conversation;
        }
    }
}

