/*
 * Decompiled with CFR 0.152.
 */
package com.nexmo.sdk.conversation.core.client;

import android.content.Context;
import android.text.TextUtils;
import com.nexmo.sdk.conversation.client.event.network.CAPIAwareListener;
import com.nexmo.sdk.conversation.client.event.network.CAPIInternalRequest;
import com.nexmo.sdk.conversation.client.event.network.NetworkState;
import com.nexmo.sdk.conversation.client.event.network.NetworkingStateListener;
import com.nexmo.sdk.conversation.client.event.network.SubscriptionListener;
import com.nexmo.sdk.conversation.core.MapList;
import com.nexmo.sdk.conversation.core.client.request.Request;
import com.nexmo.sdk.conversation.core.persistence.RequestQueueStorage;
import com.nexmo.sdk.conversation.core.util.Log;
import io.socket.client.IO;
import io.socket.client.Socket;
import io.socket.emitter.Emitter;
import io.socket.parser.Packet;
import java.net.URISyntaxException;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class Router
extends Emitter {
    private static final String TAG = Router.class.getSimpleName();
    public static boolean DEBUG_INCOMING_DATA = false;
    private NetworkState connectionStatus = NetworkState.DISCONNECTED;
    private Map<String, CAPIInternalRequest> pendingRequests = new ConcurrentHashMap<String, CAPIInternalRequest>();
    private MapList<SubscriptionListener> subscriptions = new MapList();
    private Socket socket;
    private final NetworkingStateListener connectionEventListener;
    private final boolean persistRequests;
    private final Context context;
    private Emitter.Listener listener = new Emitter.Listener(){

        public void call(Object ... args) {
            String eventName = null;
            JSONObject eventData = null;
            try {
                Packet packet = (Packet)args[0];
                JSONArray data = (JSONArray)packet.data;
                if (data.length() != 2) {
                    return;
                }
                eventName = data.getString(0);
                eventData = data.getJSONObject(1);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            if (eventName == null || eventData == null) {
                return;
            }
            Router.this.dispatch(eventName, eventData);
        }
    };

    public Router(Context context, NetworkingStateListener connectionEventListener, boolean persistRequests) {
        this.context = context.getApplicationContext();
        this.connectionEventListener = connectionEventListener;
        this.persistRequests = persistRequests;
    }

    public void connect(String connectionUrl, String path, boolean autoReconnect) throws URISyntaxException {
        IO.Options options = new IO.Options();
        options.forceNew = true;
        options.path = path;
        options.transports = new String[]{"websocket"};
        if (autoReconnect) {
            options.reconnectionDelay = 10000L;
            options.randomizationFactor = 0.2;
            options.reconnectionDelayMax = 120000L;
            options.timeout = 20000L;
        } else {
            options.reconnection = false;
        }
        this.socket = IO.socket((String)connectionUrl, (IO.Options)options);
        System.out.println("Socket instance " + this.socket);
        this.socket.on("connect", (Emitter.Listener)new NetworkStateHandler(NetworkState.CONNECTED));
        this.socket.on("connect_error", (Emitter.Listener)new NetworkStateHandler(NetworkState.CONNECT_ERROR));
        this.socket.on("connect_timeout", (Emitter.Listener)new NetworkStateHandler(NetworkState.CONNECT_TIMEOUT));
        this.socket.on("disconnect", (Emitter.Listener)new NetworkStateHandler(NetworkState.DISCONNECTED));
        this.socket.on("reconnect", (Emitter.Listener)new NetworkStateHandler(NetworkState.RECONNECT));
        this.socket.on("reconnect_failed", (Emitter.Listener)new NetworkStateHandler(NetworkState.DISCONNECTED));
        if (DEBUG_INCOMING_DATA) {
            this.socket.io().on("packet", new Emitter.Listener(){

                public void call(Object ... args) {
                    Packet p = (Packet)args[0];
                    System.err.println(Thread.currentThread().toString() + " PACKET: " + p.data);
                }
            });
        }
        this.socket.io().on("packet", this.listener);
        Log.d(TAG, "Connecting to " + connectionUrl);
        this.socket.connect();
    }

    public void shutdown() {
        this.socket.emit("disconnect", new Object[]{""});
        this.socket.io().off();
        this.socket.off();
        this.socket.disconnect();
        this.off();
    }

    @Deprecated
    public Emitter emit(String event, Object ... args) {
        return super.emit(event, args);
    }

    @Deprecated
    public Emitter once(String event, Emitter.Listener fn) {
        throw new IllegalArgumentException("For request-response you have to use sendRequest method instead");
    }

    public void sendRequest(Request request, CAPIAwareListener listener) {
        Log.i(TAG, "sendRequest " + request.getRequestName() + ": " + request.toString());
        this.pendingRequests.put(request.getTid(), new CAPIInternalRequest(request, listener));
        if (request.isPersistable()) {
            this.updatePersistentStorage();
        }
        if (this.socket != null) {
            this.socket.emit(request.getRequestName(), new Object[]{request.toJson()});
        }
    }

    private void updatePersistentStorage() {
        if (!this.persistRequests) {
            return;
        }
        new RequestQueueStorage(this.context, this.pendingRequests.values()).save();
    }

    public void loadAndRemoveAndFlush(Router router, FlushFinishedListener readyToCallUserCallback) {
        if (!this.persistRequests) {
            return;
        }
        RequestQueueStorage storage = new RequestQueueStorage(this.context, this.pendingRequests.values());
        storage.loadAndRemoveAndFlush(router, readyToCallUserCallback);
    }

    public void on(String eventName, SubscriptionListener subscription) {
        this.subscriptions.addIfNotExists(eventName, subscription);
    }

    public Emitter off() {
        this.subscriptions.clear();
        return super.off();
    }

    private void dispatch(String eventName, JSONObject eventData) {
        String rid = eventData.optString("rid");
        String cid = eventData.optString("cid");
        if (!TextUtils.isEmpty((CharSequence)rid)) {
            this.dispatchResponse(eventName, rid, cid, eventData);
        }
        for (SubscriptionListener subscription : this.subscriptions.getList(eventName)) {
            try {
                subscription.onData(eventName, eventData);
            }
            catch (JSONException e) {
                e.printStackTrace();
            }
        }
        for (Emitter.Listener l : this.listeners(eventName)) {
            l.call(new Object[]{eventData});
        }
    }

    private void dispatchResponse(String eventName, String tid, String cid, JSONObject data) {
        CAPIInternalRequest request = this.pendingRequests.remove(tid);
        if (request == null) {
            Log.w(TAG, "Got event " + eventName + " for unknown tid: " + tid);
            return;
        }
        if (request.getListener() == null) {
            return;
        }
        if (!request.getRequest().getSuccessEventName().equals(eventName)) {
            try {
                request.getListener().onError(eventName, data, tid, cid);
            }
            catch (Throwable throwable) {
                Log.w(TAG, "Got error during error processing ");
                throwable.printStackTrace();
            }
        } else {
            try {
                request.getListener().onRawUnprocessResponseData(data, tid, cid);
            }
            catch (Throwable throwable) {
                Log.w(TAG, "Got error during response processing ");
                throwable.printStackTrace();
                request.getListener().onError(eventName, data, tid, cid);
            }
        }
        if (request.getRequest().isPersistable()) {
            this.updatePersistentStorage();
        }
    }

    public synchronized void updateConnectionStatus(NetworkState networkState) {
        this.connectionStatus = networkState;
    }

    public boolean connected() {
        return this.socket.connected();
    }

    public NetworkState getConnectionStatus() {
        return this.connectionStatus;
    }

    public Map<String, CAPIInternalRequest> getPendingRequests() {
        return this.pendingRequests;
    }

    private class NetworkStateHandler
    implements Emitter.Listener {
        private NetworkState state;

        private NetworkStateHandler(NetworkState state) {
            this.state = state;
        }

        public final void call(Object ... args) {
            Log.d(TAG, "NetworkStateListener: new state: " + (Object)((Object)this.state));
            Router.this.updateConnectionStatus(this.state);
            if (Router.this.connectionEventListener != null) {
                Router.this.connectionEventListener.onNetworkingState(this.state);
            }
        }
    }

    public static interface FlushFinishedListener {
        public void onFlushFinished();
    }
}

