/*
 * Decompiled with CFR 0.152.
 */
package com.nexmo.sdk.conversation.client.audio;

import android.content.Context;
import android.os.Environment;
import android.os.ParcelFileDescriptor;
import com.nexmo.sdk.conversation.client.audio.AppRTCClient;
import com.nexmo.sdk.conversation.core.util.Log;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.webrtc.AudioSource;
import org.webrtc.AudioTrack;
import org.webrtc.DataChannel;
import org.webrtc.IceCandidate;
import org.webrtc.Logging;
import org.webrtc.MediaConstraints;
import org.webrtc.MediaStream;
import org.webrtc.PeerConnection;
import org.webrtc.PeerConnectionFactory;
import org.webrtc.RtpReceiver;
import org.webrtc.SdpObserver;
import org.webrtc.SessionDescription;
import org.webrtc.StatsObserver;
import org.webrtc.StatsReport;
import org.webrtc.voiceengine.WebRtcAudioManager;
import org.webrtc.voiceengine.WebRtcAudioRecord;
import org.webrtc.voiceengine.WebRtcAudioTrack;
import org.webrtc.voiceengine.WebRtcAudioUtils;

public class PeerConnectionClient {
    public static final String AUDIO_TRACK_ID = "ARDAMSa0";
    private static final String TAG = "PCRTCClient";
    private static final String AUDIO_CODEC_OPUS = "opus";
    private static final String AUDIO_CODEC_ISAC = "ISAC";
    private static final String DISABLE_WEBRTC_AGC_FIELDTRIAL = "WebRTC-Audio-MinimizeResamplingOnMobile/Enabled/";
    private static final String AUDIO_CODEC_PARAM_BITRATE = "maxaveragebitrate";
    private static final String AUDIO_ECHO_CANCELLATION_CONSTRAINT = "googEchoCancellation";
    private static final String AUDIO_AUTO_GAIN_CONTROL_CONSTRAINT = "googAutoGainControl";
    private static final String AUDIO_HIGH_PASS_FILTER_CONSTRAINT = "googHighpassFilter";
    private static final String AUDIO_NOISE_SUPPRESSION_CONSTRAINT = "googNoiseSuppression";
    private static final String AUDIO_LEVEL_CONTROL_CONSTRAINT = "levelControl";
    private static final String DTLS_SRTP_KEY_AGREEMENT_CONSTRAINT = "DtlsSrtpKeyAgreement";
    private static final ExecutorService executor = Executors.newSingleThreadExecutor();
    private final PCObserver pcObserver = new PCObserver();
    private final SDPObserver sdpObserver = new SDPObserver();
    private PeerConnectionFactory factory;
    private PeerConnection peerConnection;
    private AudioSource audioSource;
    private boolean preferIsac;
    private boolean isError;
    private Timer statsTimer;
    private AppRTCClient.SignalingParameters signalingParameters;
    private MediaConstraints pcConstraints;
    private MediaConstraints audioConstraints;
    private ParcelFileDescriptor aecDumpFileDescriptor;
    private MediaConstraints sdpMediaConstraints;
    private PeerConnectionParameters peerConnectionParameters;
    private LinkedList<IceCandidate> queuedRemoteCandidates;
    private PeerConnectionEvents events;
    private boolean isInitiator;
    private SessionDescription localSdp;
    private MediaStream mediaStream;
    private boolean enableAudio;
    private AudioTrack localAudioTrack;

    public void createPeerConnectionFactory(final Context context, PeerConnectionParameters peerConnectionParameters, PeerConnectionEvents events) {
        this.peerConnectionParameters = peerConnectionParameters;
        this.events = events;
        this.factory = null;
        this.peerConnection = null;
        this.preferIsac = false;
        this.isError = false;
        this.queuedRemoteCandidates = null;
        this.localSdp = null;
        this.mediaStream = null;
        this.enableAudio = true;
        this.localAudioTrack = null;
        this.statsTimer = new Timer();
        executor.execute(new Runnable(){

            @Override
            public void run() {
                PeerConnectionClient.this.createPeerConnectionFactoryInternal(context);
            }
        });
    }

    public void createPeerConnection(AppRTCClient.SignalingParameters signalingParameters) {
        if (this.peerConnectionParameters == null) {
            Log.e(TAG, "Creating peer connection without initializing factory.");
            return;
        }
        this.signalingParameters = signalingParameters;
        executor.execute(new Runnable(){

            @Override
            public void run() {
                try {
                    PeerConnectionClient.this.createMediaConstraintsInternal();
                    PeerConnectionClient.this.createPeerConnectionInternal();
                }
                catch (Exception e) {
                    PeerConnectionClient.this.reportError("Failed to create peer connection: " + e.getMessage());
                    throw e;
                }
            }
        });
    }

    public void close() {
        executor.execute(new Runnable(){

            @Override
            public void run() {
                PeerConnectionClient.this.closeInternal();
            }
        });
    }

    private void createPeerConnectionFactoryInternal(Context context) {
        Log.d(TAG, "Create peer connection factory");
        this.isError = false;
        String fieldTrials = "";
        if (this.peerConnectionParameters.disableWebRtcAGCAndHPF) {
            fieldTrials = fieldTrials + DISABLE_WEBRTC_AGC_FIELDTRIAL;
            Log.d(TAG, "Disable WebRTC AGC field trial.");
        }
        PeerConnectionFactory.initializeFieldTrials((String)fieldTrials);
        Log.d(TAG, "Field trials: " + fieldTrials);
        boolean bl = this.preferIsac = this.peerConnectionParameters.audioCodec != null && this.peerConnectionParameters.audioCodec.equals(AUDIO_CODEC_ISAC);
        if (!this.peerConnectionParameters.useOpenSLES) {
            Log.d(TAG, "Disable OpenSL ES audio even if device supports it");
            WebRtcAudioManager.setBlacklistDeviceForOpenSLESUsage((boolean)true);
        } else {
            Log.d(TAG, "Allow OpenSL ES audio if device supports it");
            WebRtcAudioManager.setBlacklistDeviceForOpenSLESUsage((boolean)false);
        }
        if (this.peerConnectionParameters.disableBuiltInAEC) {
            Log.d(TAG, "Disable built-in AEC even if device supports it");
            WebRtcAudioUtils.setWebRtcBasedAcousticEchoCanceler((boolean)true);
        } else {
            Log.d(TAG, "Enable built-in AEC if device supports it");
            WebRtcAudioUtils.setWebRtcBasedAcousticEchoCanceler((boolean)false);
        }
        if (this.peerConnectionParameters.disableBuiltInAGC) {
            Log.d(TAG, "Disable built-in AGC even if device supports it");
            WebRtcAudioUtils.setWebRtcBasedAutomaticGainControl((boolean)true);
        } else {
            Log.d(TAG, "Enable built-in AGC if device supports it");
            WebRtcAudioUtils.setWebRtcBasedAutomaticGainControl((boolean)false);
        }
        if (this.peerConnectionParameters.disableBuiltInNS) {
            Log.d(TAG, "Disable built-in NS even if device supports it");
            WebRtcAudioUtils.setWebRtcBasedNoiseSuppressor((boolean)true);
        } else {
            Log.d(TAG, "Enable built-in NS if device supports it");
            WebRtcAudioUtils.setWebRtcBasedNoiseSuppressor((boolean)false);
        }
        WebRtcAudioRecord.setErrorCallback((WebRtcAudioRecord.WebRtcAudioRecordErrorCallback)new WebRtcAudioRecord.WebRtcAudioRecordErrorCallback(){

            public void onWebRtcAudioRecordInitError(String errorMessage) {
                Log.e(PeerConnectionClient.TAG, "onWebRtcAudioRecordInitError: " + errorMessage);
                PeerConnectionClient.this.reportError(errorMessage);
            }

            public void onWebRtcAudioRecordStartError(WebRtcAudioRecord.AudioRecordStartErrorCode errorCode, String errorMessage) {
                Log.e(PeerConnectionClient.TAG, "onWebRtcAudioRecordStartError: " + errorCode + ". " + errorMessage);
                PeerConnectionClient.this.reportError(errorMessage);
            }

            public void onWebRtcAudioRecordError(String errorMessage) {
                Log.e(PeerConnectionClient.TAG, "onWebRtcAudioRecordError: " + errorMessage);
                PeerConnectionClient.this.reportError(errorMessage);
            }
        });
        WebRtcAudioTrack.setErrorCallback((WebRtcAudioTrack.WebRtcAudioTrackErrorCallback)new WebRtcAudioTrack.WebRtcAudioTrackErrorCallback(){

            public void onWebRtcAudioTrackInitError(String errorMessage) {
                PeerConnectionClient.this.reportError(errorMessage);
            }

            public void onWebRtcAudioTrackStartError(String errorMessage) {
                PeerConnectionClient.this.reportError(errorMessage);
            }

            public void onWebRtcAudioTrackError(String errorMessage) {
                PeerConnectionClient.this.reportError(errorMessage);
            }
        });
        PeerConnectionFactory.initializeAndroidGlobals((Context)context, (boolean)false);
        this.factory = new PeerConnectionFactory(null);
        Log.d(TAG, "Peer connection factory created.");
    }

    private void createMediaConstraintsInternal() {
        this.pcConstraints = new MediaConstraints();
        this.pcConstraints.optional.add(new MediaConstraints.KeyValuePair(DTLS_SRTP_KEY_AGREEMENT_CONSTRAINT, "true"));
        this.audioConstraints = new MediaConstraints();
        if (this.peerConnectionParameters.noAudioProcessing) {
            Log.d(TAG, "Disabling audio processing");
            this.audioConstraints.mandatory.add(new MediaConstraints.KeyValuePair(AUDIO_ECHO_CANCELLATION_CONSTRAINT, "false"));
            this.audioConstraints.mandatory.add(new MediaConstraints.KeyValuePair(AUDIO_AUTO_GAIN_CONTROL_CONSTRAINT, "false"));
            this.audioConstraints.mandatory.add(new MediaConstraints.KeyValuePair(AUDIO_HIGH_PASS_FILTER_CONSTRAINT, "false"));
            this.audioConstraints.mandatory.add(new MediaConstraints.KeyValuePair(AUDIO_NOISE_SUPPRESSION_CONSTRAINT, "false"));
        }
        if (this.peerConnectionParameters.enableLevelControl) {
            Log.d(TAG, "Enabling level control.");
            this.audioConstraints.mandatory.add(new MediaConstraints.KeyValuePair(AUDIO_LEVEL_CONTROL_CONSTRAINT, "true"));
        }
        this.sdpMediaConstraints = new MediaConstraints();
        this.sdpMediaConstraints.mandatory.add(new MediaConstraints.KeyValuePair("OfferToReceiveAudio", "true"));
        this.sdpMediaConstraints.mandatory.add(new MediaConstraints.KeyValuePair("OfferToReceiveVideo", "false"));
    }

    private void createPeerConnectionInternal() {
        if (this.factory == null || this.isError) {
            Log.e(TAG, "Peerconnection factory is not created");
            return;
        }
        Log.d(TAG, "Create peer connection.");
        Log.d(TAG, "PCConstraints: " + this.pcConstraints.toString());
        this.queuedRemoteCandidates = new LinkedList();
        PeerConnection.RTCConfiguration rtcConfig = new PeerConnection.RTCConfiguration(this.signalingParameters.turnServers);
        rtcConfig.tcpCandidatePolicy = PeerConnection.TcpCandidatePolicy.DISABLED;
        rtcConfig.bundlePolicy = PeerConnection.BundlePolicy.MAXBUNDLE;
        rtcConfig.rtcpMuxPolicy = PeerConnection.RtcpMuxPolicy.REQUIRE;
        rtcConfig.continualGatheringPolicy = PeerConnection.ContinualGatheringPolicy.GATHER_ONCE;
        rtcConfig.keyType = PeerConnection.KeyType.ECDSA;
        this.peerConnection = this.factory.createPeerConnection(rtcConfig, this.pcConstraints, (PeerConnection.Observer)this.pcObserver);
        this.isInitiator = false;
        Logging.enableTracing((String)"logcat:", EnumSet.of(Logging.TraceLevel.TRACE_DEFAULT));
        Logging.enableLogToDebugOutput((Logging.Severity)Logging.Severity.LS_INFO);
        this.mediaStream = this.factory.createLocalMediaStream("ARDAMS");
        this.mediaStream.addTrack(this.createAudioTrack());
        this.peerConnection.addStream(this.mediaStream);
        if (this.peerConnectionParameters.aecDump) {
            try {
                this.aecDumpFileDescriptor = ParcelFileDescriptor.open((File)new File(Environment.getExternalStorageDirectory().getPath() + File.separator + "Download/audio.aecdump"), (int)0x3C000000);
                this.factory.startAecDump(this.aecDumpFileDescriptor.getFd(), -1);
            }
            catch (IOException e) {
                Log.e(TAG, "Can not open aecdump file", e);
            }
        }
        Log.d(TAG, "Peer connection created.");
    }

    private void closeInternal() {
        Log.d(TAG, "closeInternal");
        if (this.factory != null && this.peerConnectionParameters.aecDump) {
            this.factory.stopAecDump();
        }
        Log.d(TAG, "Closing peer connection.");
        this.statsTimer.cancel();
        if (this.peerConnection != null) {
            this.peerConnection.dispose();
            this.peerConnection = null;
        }
        Log.d(TAG, "Closing audio source.");
        if (this.audioSource != null) {
            this.audioSource.dispose();
            this.audioSource = null;
        }
        Log.d(TAG, "Closing peer connection factory.");
        if (this.factory != null) {
            this.factory.dispose();
            this.factory = null;
        }
        Log.d(TAG, "Closing peer connection done.");
        this.events.onPeerConnectionClosed();
        this.events = null;
    }

    private void getStats() {
        if (this.peerConnection == null || this.isError) {
            return;
        }
        boolean success = this.peerConnection.getStats(new StatsObserver(){

            public void onComplete(StatsReport[] reports) {
                PeerConnectionClient.this.events.onPeerConnectionStatsReady(reports);
            }
        }, null);
        if (!success) {
            Log.e(TAG, "getStats() returns false!");
        }
    }

    public void enableStatsEvents(boolean enable, int periodMs) {
        if (enable) {
            try {
                this.statsTimer.schedule(new TimerTask(){

                    @Override
                    public void run() {
                        executor.execute(new Runnable(){

                            @Override
                            public void run() {
                                PeerConnectionClient.this.getStats();
                            }
                        });
                    }
                }, 0L, (long)periodMs);
            }
            catch (Exception e) {
                Log.e(TAG, "Can not schedule statistics timer", e);
            }
        } else {
            this.statsTimer.cancel();
        }
    }

    public void setAudioEnabled(final boolean enable) {
        executor.execute(new Runnable(){

            @Override
            public void run() {
                PeerConnectionClient.this.enableAudio = enable;
                if (PeerConnectionClient.this.localAudioTrack != null) {
                    PeerConnectionClient.this.localAudioTrack.setEnabled(PeerConnectionClient.this.enableAudio);
                }
            }
        });
    }

    public void createOffer() {
        executor.execute(new Runnable(){

            @Override
            public void run() {
                if (PeerConnectionClient.this.peerConnection != null && !PeerConnectionClient.this.isError) {
                    Log.d(PeerConnectionClient.TAG, "PC Create OFFER");
                    PeerConnectionClient.this.isInitiator = true;
                    PeerConnectionClient.this.peerConnection.createOffer((SdpObserver)PeerConnectionClient.this.sdpObserver, PeerConnectionClient.this.sdpMediaConstraints);
                }
            }
        });
    }

    public void createAnswer() {
        executor.execute(new Runnable(){

            @Override
            public void run() {
                if (PeerConnectionClient.this.peerConnection != null && !PeerConnectionClient.this.isError) {
                    Log.d(PeerConnectionClient.TAG, "PC create ANSWER");
                    PeerConnectionClient.this.isInitiator = false;
                    PeerConnectionClient.this.peerConnection.createAnswer((SdpObserver)PeerConnectionClient.this.sdpObserver, PeerConnectionClient.this.sdpMediaConstraints);
                }
            }
        });
    }

    public void addRemoteIceCandidate(final IceCandidate candidate) {
        executor.execute(new Runnable(){

            @Override
            public void run() {
                if (PeerConnectionClient.this.peerConnection != null && !PeerConnectionClient.this.isError) {
                    if (PeerConnectionClient.this.queuedRemoteCandidates != null) {
                        PeerConnectionClient.this.queuedRemoteCandidates.add(candidate);
                    } else {
                        PeerConnectionClient.this.peerConnection.addIceCandidate(candidate);
                    }
                }
            }
        });
    }

    public void removeRemoteIceCandidates(final IceCandidate[] candidates) {
        executor.execute(new Runnable(){

            @Override
            public void run() {
                if (PeerConnectionClient.this.peerConnection == null || PeerConnectionClient.this.isError) {
                    return;
                }
                PeerConnectionClient.this.drainCandidates();
                PeerConnectionClient.this.peerConnection.removeIceCandidates(candidates);
            }
        });
    }

    public void setRemoteDescription(final SessionDescription sdp) {
        executor.execute(new Runnable(){

            @Override
            public void run() {
                if (PeerConnectionClient.this.peerConnection == null || PeerConnectionClient.this.isError) {
                    return;
                }
                String sdpDescription = sdp.description;
                if (PeerConnectionClient.this.preferIsac) {
                    sdpDescription = PeerConnectionClient.preferCodec(sdpDescription, PeerConnectionClient.AUDIO_CODEC_ISAC, true);
                }
                if (((PeerConnectionClient)PeerConnectionClient.this).peerConnectionParameters.audioStartBitrate > 0) {
                    sdpDescription = PeerConnectionClient.setStartBitrate(PeerConnectionClient.AUDIO_CODEC_OPUS, false, sdpDescription, ((PeerConnectionClient)PeerConnectionClient.this).peerConnectionParameters.audioStartBitrate);
                }
                Log.d(PeerConnectionClient.TAG, "Set remote SDP.");
                SessionDescription sdpRemote = new SessionDescription(sdp.type, sdpDescription);
                PeerConnectionClient.this.peerConnection.setRemoteDescription((SdpObserver)PeerConnectionClient.this.sdpObserver, sdpRemote);
            }
        });
    }

    private void reportError(final String errorMessage) {
        Log.e(TAG, "Peerconnection error: " + errorMessage);
        executor.execute(new Runnable(){

            @Override
            public void run() {
                if (!PeerConnectionClient.this.isError) {
                    PeerConnectionClient.this.events.onPeerConnectionError(errorMessage);
                    PeerConnectionClient.this.isError = true;
                }
            }
        });
    }

    private AudioTrack createAudioTrack() {
        this.audioSource = this.factory.createAudioSource(this.audioConstraints);
        this.localAudioTrack = this.factory.createAudioTrack(AUDIO_TRACK_ID, this.audioSource);
        this.localAudioTrack.setEnabled(this.enableAudio);
        return this.localAudioTrack;
    }

    private static String setStartBitrate(String codec, boolean isVideoCodec, String sdpDescription, int bitrateKbps) {
        Matcher codecMatcher;
        int i;
        String[] lines = sdpDescription.split("\r\n");
        int rtpmapLineIndex = -1;
        boolean sdpFormatUpdated = false;
        String codecRtpMap = null;
        String regex = "^a=rtpmap:(\\d+) " + codec + "(/\\d+)+[\r]?$";
        Pattern codecPattern = Pattern.compile(regex);
        for (i = 0; i < lines.length; ++i) {
            codecMatcher = codecPattern.matcher(lines[i]);
            if (!codecMatcher.matches()) continue;
            codecRtpMap = codecMatcher.group(1);
            rtpmapLineIndex = i;
            break;
        }
        if (codecRtpMap == null) {
            Log.w(TAG, "No rtpmap for " + codec + " codec");
            return sdpDescription;
        }
        Log.d(TAG, "Found " + codec + " rtpmap " + codecRtpMap + " at " + lines[rtpmapLineIndex]);
        regex = "^a=fmtp:" + codecRtpMap + " \\w+=\\d+.*[\r]?$";
        codecPattern = Pattern.compile(regex);
        for (i = 0; i < lines.length; ++i) {
            codecMatcher = codecPattern.matcher(lines[i]);
            if (!codecMatcher.matches()) continue;
            Log.d(TAG, "Found " + codec + " " + lines[i]);
            int n = i;
            lines[n] = lines[n] + "; maxaveragebitrate=" + bitrateKbps * 1000;
            Log.d(TAG, "Update remote SDP line: " + lines[i]);
            sdpFormatUpdated = true;
            break;
        }
        StringBuilder newSdpDescription = new StringBuilder();
        for (int i2 = 0; i2 < lines.length; ++i2) {
            newSdpDescription.append(lines[i2]).append("\r\n");
            if (sdpFormatUpdated || i2 != rtpmapLineIndex) continue;
            String bitrateSet = "a=fmtp:" + codecRtpMap + " " + AUDIO_CODEC_PARAM_BITRATE + "=" + bitrateKbps * 1000;
            Log.d(TAG, "Add remote SDP line: " + bitrateSet);
            newSdpDescription.append(bitrateSet).append("\r\n");
        }
        return newSdpDescription.toString();
    }

    private static int findMediaDescriptionLine(boolean isAudio, String[] sdpLines) {
        String mediaDescription = isAudio ? "m=audio " : "m=video ";
        for (int i = 0; i < sdpLines.length; ++i) {
            if (!sdpLines[i].startsWith(mediaDescription)) continue;
            return i;
        }
        return -1;
    }

    private static String joinString(Iterable<? extends CharSequence> s, String delimiter, boolean delimiterAtEnd) {
        Iterator<? extends CharSequence> iter = s.iterator();
        if (!iter.hasNext()) {
            return "";
        }
        StringBuilder buffer = new StringBuilder(iter.next());
        while (iter.hasNext()) {
            buffer.append(delimiter).append(iter.next());
        }
        if (delimiterAtEnd) {
            buffer.append(delimiter);
        }
        return buffer.toString();
    }

    private static String movePayloadTypesToFront(List<String> preferredPayloadTypes, String mLine) {
        List<String> origLineParts = Arrays.asList(mLine.split(" "));
        if (origLineParts.size() <= 3) {
            Log.e(TAG, "Wrong SDP media description format: " + mLine);
            return null;
        }
        List<String> header = origLineParts.subList(0, 3);
        ArrayList<String> unpreferredPayloadTypes = new ArrayList<String>(origLineParts.subList(3, origLineParts.size()));
        unpreferredPayloadTypes.removeAll(preferredPayloadTypes);
        ArrayList<String> newLineParts = new ArrayList<String>();
        newLineParts.addAll(header);
        newLineParts.addAll(preferredPayloadTypes);
        newLineParts.addAll(unpreferredPayloadTypes);
        return PeerConnectionClient.joinString(newLineParts, " ", false);
    }

    private static String preferCodec(String sdpDescription, String codec, boolean isAudio) {
        String[] lines = sdpDescription.split("\r\n");
        int mLineIndex = PeerConnectionClient.findMediaDescriptionLine(isAudio, lines);
        if (mLineIndex == -1) {
            Log.w(TAG, "No mediaDescription line, so can't prefer " + codec);
            return sdpDescription;
        }
        ArrayList<String> codecPayloadTypes = new ArrayList<String>();
        Pattern codecPattern = Pattern.compile("^a=rtpmap:(\\d+) " + codec + "(/\\d+)+[\r]?$");
        for (int i = 0; i < lines.length; ++i) {
            Matcher codecMatcher = codecPattern.matcher(lines[i]);
            if (!codecMatcher.matches()) continue;
            codecPayloadTypes.add(codecMatcher.group(1));
        }
        if (codecPayloadTypes.isEmpty()) {
            Log.w(TAG, "No payload types with name " + codec);
            return sdpDescription;
        }
        String newMLine = PeerConnectionClient.movePayloadTypesToFront(codecPayloadTypes, lines[mLineIndex]);
        if (newMLine == null) {
            return sdpDescription;
        }
        Log.d(TAG, "Change media description from: " + lines[mLineIndex] + " to " + newMLine);
        lines[mLineIndex] = newMLine;
        return PeerConnectionClient.joinString(Arrays.asList(lines), "\r\n", true);
    }

    private void drainCandidates() {
        if (this.queuedRemoteCandidates != null) {
            Log.d(TAG, "Add " + this.queuedRemoteCandidates.size() + " remote candidates");
            for (IceCandidate candidate : this.queuedRemoteCandidates) {
                this.peerConnection.addIceCandidate(candidate);
            }
            this.queuedRemoteCandidates = null;
        }
    }

    public SessionDescription getLocalDescription() {
        return this.peerConnection.getLocalDescription();
    }

    private class SDPObserver
    implements SdpObserver {
        private SDPObserver() {
        }

        public void onCreateSuccess(SessionDescription origSdp) {
            if (PeerConnectionClient.this.localSdp != null) {
                PeerConnectionClient.this.reportError("Multiple SDP create.");
                return;
            }
            String sdpDescription = origSdp.description;
            if (PeerConnectionClient.this.preferIsac) {
                sdpDescription = PeerConnectionClient.preferCodec(sdpDescription, PeerConnectionClient.AUDIO_CODEC_ISAC, true);
            }
            final SessionDescription sdp = new SessionDescription(origSdp.type, sdpDescription);
            PeerConnectionClient.this.localSdp = sdp;
            executor.execute(new Runnable(){

                @Override
                public void run() {
                    if (PeerConnectionClient.this.peerConnection != null && !PeerConnectionClient.this.isError) {
                        Log.d(PeerConnectionClient.TAG, "Set local SDP from " + sdp.type);
                        PeerConnectionClient.this.peerConnection.setLocalDescription((SdpObserver)PeerConnectionClient.this.sdpObserver, sdp);
                    }
                }
            });
        }

        public void onSetSuccess() {
            executor.execute(new Runnable(){

                @Override
                public void run() {
                    if (PeerConnectionClient.this.peerConnection == null || PeerConnectionClient.this.isError) {
                        return;
                    }
                    if (PeerConnectionClient.this.isInitiator) {
                        if (PeerConnectionClient.this.peerConnection.getRemoteDescription() == null) {
                            Log.d(PeerConnectionClient.TAG, "Local SDP set succesfully");
                            PeerConnectionClient.this.events.onLocalDescription(PeerConnectionClient.this.localSdp);
                        } else {
                            Log.d(PeerConnectionClient.TAG, "Remote SDP set succesfully");
                            PeerConnectionClient.this.drainCandidates();
                        }
                    } else if (PeerConnectionClient.this.peerConnection.getLocalDescription() != null) {
                        Log.d(PeerConnectionClient.TAG, "Local SDP set succesfully");
                        PeerConnectionClient.this.events.onLocalDescription(PeerConnectionClient.this.localSdp);
                        PeerConnectionClient.this.drainCandidates();
                    } else {
                        Log.d(PeerConnectionClient.TAG, "Remote SDP set succesfully");
                    }
                }
            });
        }

        public void onCreateFailure(String error) {
            PeerConnectionClient.this.reportError("createSDP error: " + error);
        }

        public void onSetFailure(String error) {
            PeerConnectionClient.this.reportError("setSDP error: " + error);
        }
    }

    private class PCObserver
    implements PeerConnection.Observer {
        private PCObserver() {
        }

        public void onIceCandidate(final IceCandidate candidate) {
            executor.execute(new Runnable(){

                @Override
                public void run() {
                    PeerConnectionClient.this.events.onIceCandidate(candidate);
                }
            });
        }

        public void onIceCandidatesRemoved(final IceCandidate[] candidates) {
            executor.execute(new Runnable(){

                @Override
                public void run() {
                    PeerConnectionClient.this.events.onIceCandidatesRemoved(candidates);
                }
            });
        }

        public void onSignalingChange(PeerConnection.SignalingState newState) {
            Log.d(PeerConnectionClient.TAG, "SignalingState: " + newState);
        }

        public void onIceConnectionChange(final PeerConnection.IceConnectionState newState) {
            executor.execute(new Runnable(){

                @Override
                public void run() {
                    Log.d(PeerConnectionClient.TAG, "IceConnectionState: " + newState);
                    if (newState == PeerConnection.IceConnectionState.CONNECTED) {
                        PeerConnectionClient.this.events.onIceConnected();
                    } else if (newState == PeerConnection.IceConnectionState.DISCONNECTED) {
                        PeerConnectionClient.this.events.onIceDisconnected();
                    } else if (newState == PeerConnection.IceConnectionState.FAILED) {
                        PeerConnectionClient.this.reportError("ICE connection failed.");
                    }
                }
            });
        }

        public void onIceGatheringChange(PeerConnection.IceGatheringState newState) {
            Log.d(PeerConnectionClient.TAG, "IceGatheringState: " + newState);
            if (newState == PeerConnection.IceGatheringState.COMPLETE) {
                PeerConnectionClient.this.events.onIceGatheringDone();
            }
        }

        public void onIceConnectionReceivingChange(boolean receiving) {
            Log.d(PeerConnectionClient.TAG, "IceConnectionReceiving changed to " + receiving);
        }

        public void onAddStream(final MediaStream stream) {
            executor.execute(new Runnable(){

                @Override
                public void run() {
                    if (PeerConnectionClient.this.peerConnection == null || PeerConnectionClient.this.isError) {
                        return;
                    }
                    if (stream.audioTracks.size() > 1) {
                        PeerConnectionClient.this.reportError("Weird-looking stream: " + stream);
                        return;
                    }
                    if (stream.videoTracks.size() > 0) {
                        PeerConnectionClient.this.reportError("Video is unsupported in stream: " + stream);
                        return;
                    }
                }
            });
        }

        public void onRemoveStream(MediaStream stream) {
        }

        public void onDataChannel(DataChannel dc) {
            Log.d(PeerConnectionClient.TAG, "NOT IMPLEMENTED - New Data channel " + dc.label());
        }

        public void onRenegotiationNeeded() {
        }

        public void onAddTrack(RtpReceiver receiver, MediaStream[] mediaStreams) {
        }
    }

    public static interface PeerConnectionEvents {
        public void onLocalDescription(SessionDescription var1);

        public void onIceCandidate(IceCandidate var1);

        public void onIceCandidatesRemoved(IceCandidate[] var1);

        public void onIceConnected();

        public void onIceDisconnected();

        public void onPeerConnectionClosed();

        public void onPeerConnectionStatsReady(StatsReport[] var1);

        public void onPeerConnectionError(String var1);

        public void onIceGatheringDone();
    }

    public static class PeerConnectionParameters {
        public final boolean tracing;
        public final int audioStartBitrate;
        public final String audioCodec;
        public final boolean noAudioProcessing;
        public final boolean aecDump;
        public final boolean useOpenSLES;
        public final boolean disableBuiltInAEC;
        public final boolean disableBuiltInAGC;
        public final boolean disableBuiltInNS;
        public final boolean enableLevelControl;
        public final boolean disableWebRtcAGCAndHPF;

        public PeerConnectionParameters(boolean tracing, int audioStartBitrate, String audioCodec, boolean noAudioProcessing, boolean aecDump, boolean useOpenSLES, boolean disableBuiltInAEC, boolean disableBuiltInAGC, boolean disableBuiltInNS, boolean enableLevelControl, boolean disableWebRtcAGCAndHPF) {
            this.tracing = tracing;
            this.audioStartBitrate = audioStartBitrate;
            this.audioCodec = audioCodec;
            this.noAudioProcessing = noAudioProcessing;
            this.aecDump = aecDump;
            this.useOpenSLES = useOpenSLES;
            this.disableBuiltInAEC = disableBuiltInAEC;
            this.disableBuiltInAGC = disableBuiltInAGC;
            this.disableBuiltInNS = disableBuiltInNS;
            this.enableLevelControl = enableLevelControl;
            this.disableWebRtcAGCAndHPF = disableWebRtcAGCAndHPF;
        }
    }

    public static class DataChannelParameters {
        public final boolean ordered;
        public final int maxRetransmitTimeMs;
        public final int maxRetransmits;
        public final String protocol;
        public final boolean negotiated;
        public final int id;

        public DataChannelParameters(boolean ordered, int maxRetransmitTimeMs, int maxRetransmits, String protocol, boolean negotiated, int id) {
            this.ordered = ordered;
            this.maxRetransmitTimeMs = maxRetransmitTimeMs;
            this.maxRetransmits = maxRetransmits;
            this.protocol = protocol;
            this.negotiated = negotiated;
            this.id = id;
        }
    }
}

