/*
 * Decompiled with CFR 0.152.
 */
package com.nexmo.sdk.conversation.client.audio;

import android.content.Context;
import android.os.Handler;
import android.widget.Toast;
import com.nexmo.sdk.conversation.client.ConversationSignalingChannel;
import com.nexmo.sdk.conversation.client.audio.AppRTCAudioManager;
import com.nexmo.sdk.conversation.client.audio.AppRTCClient;
import com.nexmo.sdk.conversation.client.audio.AudioCallEventListener;
import com.nexmo.sdk.conversation.client.audio.PeerConnectionClient;
import com.nexmo.sdk.conversation.client.audio.RtcEvents;
import com.nexmo.sdk.conversation.client.event.NexmoAPIError;
import com.nexmo.sdk.conversation.client.event.RequestHandler;
import com.nexmo.sdk.conversation.core.util.Log;
import java.util.ArrayList;
import java.util.Set;
import org.webrtc.IceCandidate;
import org.webrtc.PeerConnection;
import org.webrtc.SessionDescription;
import org.webrtc.StatsReport;

public class AudioCallManager
implements PeerConnectionClient.PeerConnectionEvents,
RtcEvents {
    private static final String TAG = "Rtc " + AudioCallManager.class.getSimpleName();
    private static final String[] MANDATORY_PERMISSIONS = new String[]{"android.permission.MODIFY_AUDIO_SETTINGS", "android.permission.RECORD_AUDIO", "android.permission.INTERNET"};
    private static final int STAT_CALLBACK_PERIOD = 1000;
    private PeerConnectionClient peerConnectionClient = null;
    private AppRTCClient.SignalingParameters signalingParameters;
    private AppRTCAudioManager audioManager = null;
    private Toast logToast;
    private PeerConnectionClient.PeerConnectionParameters peerConnectionParameters;
    private boolean iceConnected;
    private boolean isError;
    private long callStartedTimeMs = 0L;
    private AudioCallState state = AudioCallState.ReadyForCall;
    private final Context context;
    private final Handler handler;
    private String conversationId = null;
    private String memberId;
    private String rtc_id;
    private AudioCallEventListener delegate = null;
    private ConversationSignalingChannel conversationSignalingChannel;
    private SessionDescription offer;

    public AudioCallManager(Context context, String conversationId, String memberId, ConversationSignalingChannel conversationSignalingChannel) {
        Log.d(TAG, "AudioCallManager() ctor");
        this.conversationId = conversationId;
        this.memberId = memberId;
        this.context = context;
        this.handler = new Handler(context.getMainLooper());
        this.state = AudioCallState.ReadyForCall;
        this.conversationSignalingChannel = conversationSignalingChannel;
    }

    public void enable(AudioCallEventListener listener) {
        Log.d(TAG, "enable audio " + (Object)((Object)this.state));
        if (listener == null) {
            Log.d(TAG, "Listener is mandatory");
            return;
        }
        if (this.memberId == null) {
            listener.onGeneralCallError(NexmoAPIError.noUserLoggedInForConversation(this.conversationId));
            return;
        }
        for (String permission2 : MANDATORY_PERMISSIONS) {
            if (this.context.checkCallingOrSelfPermission(permission2) == 0) continue;
            Log.e(TAG, "Permission " + permission2 + " is not granted");
            listener.onGeneralCallError(NexmoAPIError.audioMissingPermissions());
            return;
        }
        if (this.state != AudioCallState.ReadyForCall || this.conversationSignalingChannel.isAudioEnabled()) {
            listener.onGeneralCallError(NexmoAPIError.audioAlreadyInProgress());
            return;
        }
        if (this.conversationId == null || this.conversationId.length() == 0) {
            Log.e(TAG, "Incorrect room ID!");
            listener.onGeneralCallError(NexmoAPIError.missingParams());
            return;
        }
        this.startCall(listener);
    }

    public void disable(RequestHandler listener) {
        Log.d(TAG, "audio disable");
        if (listener == null) {
            Log.e(TAG, "Listener must be provided");
            return;
        }
        if (this.memberId == null) {
            listener.onError(NexmoAPIError.noUserLoggedInForConversation(this.conversationId));
            return;
        }
        for (String permission2 : MANDATORY_PERMISSIONS) {
            if (this.context.checkCallingOrSelfPermission(permission2) == 0) continue;
            Log.e(TAG, "Permission " + permission2 + " is not granted");
            listener.onError(NexmoAPIError.audioMissingPermissions());
            return;
        }
        if (this.state != AudioCallState.Connected) {
            listener.onError(NexmoAPIError.audioGeneralCallError("Audio not connected"));
            return;
        }
        this.conversationSignalingChannel.rtcTerminate(this.conversationId, this.memberId, this.rtc_id, listener);
        this.endAudioCall(listener);
    }

    public void mute(boolean isMute, RequestHandler listener) {
        Log.d(TAG, "muteSelf : isMute = " + isMute);
        if (listener == null) {
            Log.e(TAG, "Listener must be provided");
            return;
        }
        if (this.memberId == null) {
            listener.onError(NexmoAPIError.noUserLoggedInForConversation(this.conversationId));
            return;
        }
        if (this.state != AudioCallState.Connected) {
            listener.onError(NexmoAPIError.audioGeneralCallError("Audio not connected"));
            return;
        }
        if (this.peerConnectionClient != null) {
            this.peerConnectionClient.setAudioEnabled(!isMute);
            this.conversationSignalingChannel.rtcMute(this.conversationId, this.memberId, isMute, listener);
        }
    }

    public void earmuff(boolean isEarmuff, RequestHandler listener) {
        Log.d(TAG, "earmuffSelf : isEarmuff = " + isEarmuff);
        if (listener == null) {
            Log.e(TAG, "Listener must be provided");
            return;
        }
        if (this.memberId == null) {
            listener.onError(NexmoAPIError.noUserLoggedInForConversation(this.conversationId));
            return;
        }
        if (this.state != AudioCallState.Connected) {
            listener.onError(NexmoAPIError.audioGeneralCallError("Audio not connected"));
            return;
        }
        this.conversationSignalingChannel.rtcEarmuff(this.conversationId, this.memberId, isEarmuff, listener);
    }

    public void startRinging(RequestHandler listener) {
        Log.d(TAG, "startRinging");
        if (listener == null) {
            Log.e(TAG, "Listener must be provided");
            return;
        }
        if (this.memberId == null) {
            listener.onError(NexmoAPIError.noUserLoggedInForConversation(this.conversationId));
            return;
        }
        if (this.state != AudioCallState.Connected) {
            listener.onError(NexmoAPIError.audioGeneralCallError("Audio not connected"));
            return;
        }
        this.conversationSignalingChannel.mediaRinging(this.conversationId, this.memberId, true, listener);
    }

    public void stopRinging(RequestHandler listener) {
        Log.d(TAG, "stopRinging");
        if (listener == null) {
            Log.e(TAG, "Listener must be provided");
            return;
        }
        if (this.memberId == null) {
            listener.onError(NexmoAPIError.noUserLoggedInForConversation(this.conversationId));
            return;
        }
        if (this.state != AudioCallState.Connected) {
            listener.onError(NexmoAPIError.audioGeneralCallError("Audio not connected"));
            return;
        }
        this.conversationSignalingChannel.mediaRinging(this.conversationId, this.memberId, false, listener);
    }

    void startCall(AudioCallEventListener listener) {
        this.delegate = listener;
        this.state = AudioCallState.Ringing;
        this.delegate.onRinging();
        this.iceConnected = false;
        this.signalingParameters = null;
        this.peerConnectionClient = new PeerConnectionClient();
        boolean tracing = false;
        this.peerConnectionParameters = new PeerConnectionClient.PeerConnectionParameters(tracing, 0, null, false, false, false, false, false, false, false, false);
        this.peerConnectionClient.createPeerConnectionFactory(this.context, this.peerConnectionParameters, this);
        this.callStartedTimeMs = System.currentTimeMillis();
        this.audioManager = AppRTCAudioManager.create(this.context);
        Log.d(TAG, "Starting the audio manager...");
        this.audioManager.start(new AppRTCAudioManager.AudioManagerEvents(){

            @Override
            public void onAudioDeviceChanged(AppRTCAudioManager.AudioDevice audioDevice, Set<AppRTCAudioManager.AudioDevice> availableAudioDevices) {
                AudioCallManager.this.onAudioManagerDevicesChanged(audioDevice, availableAudioDevices);
            }
        });
        final AppRTCClient.SignalingParameters signallingParameters = this.setupSignallingParameters();
        Runnable runHttp = new Runnable(){

            @Override
            public void run() {
                AudioCallManager.this.initiatePeerConnection(signallingParameters);
            }
        };
        new Thread(runHttp).start();
    }

    private void endAudioCall(RequestHandler<Void> listener) {
        this.disconnect(listener);
    }

    public AudioCallState getState() {
        return this.state;
    }

    private void disconnect(RequestHandler<Void> disableListener) {
        if (this.peerConnectionClient != null) {
            this.peerConnectionClient.close();
            this.peerConnectionClient = null;
        }
        if (this.audioManager != null) {
            this.audioManager.stop();
            this.audioManager = null;
        }
        if (this.iceConnected && !this.isError) {
            this.delegate.onCallEnded();
        } else {
            this.delegate.onGeneralCallError(NexmoAPIError.audioGeneralCallError("While disconnecting"));
            if (disableListener != null) {
                disableListener.onError(NexmoAPIError.audioGeneralCallError("While disconnecting"));
            }
        }
        this.state = AudioCallState.ReadyForCall;
    }

    private void disconnectWithErrorMessage(String errorMessage) {
        this.delegate.onGeneralCallError(NexmoAPIError.audioGeneralCallError(errorMessage));
        this.disconnect(null);
    }

    @Override
    public void onAnswer(SessionDescription sdp) {
        if (this.peerConnectionClient != null) {
            this.peerConnectionClient.setRemoteDescription(sdp);
        }
    }

    private AppRTCClient.SignalingParameters setupSignallingParameters() {
        ArrayList<PeerConnection.IceServer> turnServers = new ArrayList<PeerConnection.IceServer>();
        PeerConnection.IceServer turnServer = PeerConnection.IceServer.builder((String)"turn:138.68.169.35:3478?transport=tcp").setUsername("foo2").setPassword("bar").createIceServer();
        turnServers.add(turnServer);
        return new AppRTCClient.SignalingParameters(turnServers, true, null, null);
    }

    private void callConnected() {
        long delta = System.currentTimeMillis() - this.callStartedTimeMs;
        Log.i(TAG, "Call connected: delay=" + delta + "ms");
        if (this.peerConnectionClient == null || this.isError) {
            Log.w(TAG, "Call is connected in closed or error state");
            return;
        }
        this.peerConnectionClient.enableStatsEvents(true, 1000);
        this.state = AudioCallState.Connected;
        this.delegate.onCallConnected();
    }

    private void onAudioManagerDevicesChanged(AppRTCAudioManager.AudioDevice device, Set<AppRTCAudioManager.AudioDevice> availableDevices) {
        Log.d(TAG, "onAudioManagerDevicesChanged: " + availableDevices + ", selected: " + (Object)((Object)device));
        this.delegate.onAudioRouteChange(device);
    }

    private void disconnect() {
        if (this.peerConnectionClient != null) {
            this.peerConnectionClient.close();
            this.peerConnectionClient = null;
        }
        if (this.audioManager != null) {
            this.audioManager.stop();
            this.audioManager = null;
        }
        if (this.iceConnected && !this.isError) {
            this.delegate.onCallEnded();
        } else {
            this.delegate.onGeneralCallError(NexmoAPIError.audioGeneralCallError("While disconnecting"));
        }
        this.state = AudioCallState.ReadyForCall;
    }

    private void logAndToast(String msg) {
        Log.d(TAG, msg);
        if (this.logToast != null) {
            this.logToast.cancel();
        }
        this.logToast = Toast.makeText((Context)this.context, (CharSequence)msg, (int)0);
        this.logToast.show();
    }

    private void reportError(final String description) {
        this.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                if (!AudioCallManager.this.isError) {
                    AudioCallManager.this.isError = true;
                    AudioCallManager.this.disconnectWithErrorMessage(description);
                }
            }
        });
    }

    private void initiatePeerConnection(AppRTCClient.SignalingParameters params) {
        long delta = System.currentTimeMillis() - this.callStartedTimeMs;
        this.signalingParameters = params;
        this.peerConnectionClient.createPeerConnection(this.signalingParameters);
        if (this.signalingParameters.initiator) {
            this.runOnUiThread(new Runnable(){

                @Override
                public void run() {
                    AudioCallManager.this.logAndToast("Creating OFFER...");
                }
            });
            this.peerConnectionClient.createOffer();
        } else {
            if (params.offerSdp != null) {
                this.peerConnectionClient.setRemoteDescription(params.offerSdp);
                this.runOnUiThread(new Runnable(){

                    @Override
                    public void run() {
                        AudioCallManager.this.logAndToast("Creating ANSWER...");
                    }
                });
                this.peerConnectionClient.createAnswer();
            }
            if (params.iceCandidates != null) {
                for (IceCandidate iceCandidate : params.iceCandidates) {
                    this.peerConnectionClient.addRemoteIceCandidate(iceCandidate);
                }
            }
        }
    }

    @Override
    public void onLocalDescription(SessionDescription sdp) {
        Log.d(TAG, "onLocalDescription: " + sdp.description);
        this.offer = sdp;
    }

    @Override
    public void onIceCandidate(IceCandidate candidate) {
        Log.d(TAG, "onIceCandidate: " + candidate.toString());
    }

    @Override
    public void onIceCandidatesRemoved(IceCandidate[] candidates) {
        Log.d(TAG, "onIceCandidatesRemoved: " + candidates.toString());
    }

    @Override
    public void onIceConnected() {
        Log.d(TAG, "onIceConnected");
        final long delta = System.currentTimeMillis() - this.callStartedTimeMs;
        this.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                AudioCallManager.this.logAndToast("ICE connected, delay=" + delta + "ms");
                AudioCallManager.this.iceConnected = true;
                AudioCallManager.this.callConnected();
            }
        });
    }

    @Override
    public void onIceDisconnected() {
        Log.d(TAG, "onIceDisconnected");
        this.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                AudioCallManager.this.logAndToast("ICE disconnected");
                AudioCallManager.this.iceConnected = false;
                AudioCallManager.this.disconnect();
            }
        });
    }

    @Override
    public void onPeerConnectionClosed() {
        Log.d(TAG, "onPeerConnectionClosed");
    }

    @Override
    public void onPeerConnectionStatsReady(StatsReport[] reports) {
        Log.d(TAG, "onPeerConnectionStatsReady: " + reports.toString());
    }

    @Override
    public void onPeerConnectionError(String description) {
        Log.d(TAG, "onPeerConnectionError: " + description);
        this.reportError(description);
    }

    @Override
    public void onIceGatheringDone() {
        Log.d(TAG, "onIceGatheringDone");
        Log.d(TAG, "rtc:new sdp=" + this.peerConnectionClient.getLocalDescription().description);
        this.conversationSignalingChannel.rtcNew(this.conversationId, this.memberId, this.peerConnectionClient.getLocalDescription().description, new RequestHandler(){

            @Override
            public void onError(NexmoAPIError apiError) {
                AudioCallManager.this.state = AudioCallState.ReadyForCall;
                AudioCallManager.this.delegate.onGeneralCallError(apiError);
            }

            @Override
            public void onSuccess(Object result) {
            }
        });
    }

    private void runOnUiThread(Runnable r) {
        this.handler.post(r);
    }

    public Set<AppRTCAudioManager.AudioDevice> getAvailableAudioRoutes() {
        if (this.audioManager == null) {
            Log.e(TAG, "AudioManager is not initialised");
            return null;
        }
        return this.audioManager.getAudioDevices();
    }

    public void setAudioRoute(AppRTCAudioManager.AudioDevice audioRoute) {
        if (this.audioManager == null) {
            Log.e(TAG, "AudioManager is not initialised");
            return;
        }
        this.audioManager.selectAudioDevice(audioRoute);
    }

    public void updateRtcId(String rtcId) {
        this.rtc_id = rtcId;
    }

    public static enum AudioCallState {
        ReadyForCall,
        Trying,
        Ringing,
        Connected;

    }
}

