/*
 * Decompiled with CFR 0.152.
 */
package com.nexmo.sdk.conversation.client.audio;

import android.annotation.SuppressLint;
import android.bluetooth.BluetoothAdapter;
import android.bluetooth.BluetoothDevice;
import android.bluetooth.BluetoothHeadset;
import android.bluetooth.BluetoothProfile;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.media.AudioManager;
import android.os.Handler;
import android.os.Looper;
import android.os.Process;
import com.nexmo.sdk.conversation.client.audio.AppRTCAudioManager;
import com.nexmo.sdk.conversation.client.audio.AppRTCUtils;
import com.nexmo.sdk.conversation.core.util.Log;
import java.util.List;
import java.util.Set;
import org.webrtc.ThreadUtils;

public class AppRTCBluetoothManager {
    private static final String TAG = "AppRTCBluetoothManager";
    private static final int BLUETOOTH_SCO_TIMEOUT_MS = 4000;
    private static final int MAX_SCO_CONNECTION_ATTEMPTS = 2;
    private final Context apprtcContext;
    private final AppRTCAudioManager apprtcAudioManager;
    private final AudioManager audioManager;
    private final Handler handler;
    int scoConnectionAttempts;
    private State bluetoothState;
    private final BluetoothProfile.ServiceListener bluetoothServiceListener;
    private BluetoothAdapter bluetoothAdapter;
    private BluetoothHeadset bluetoothHeadset;
    private BluetoothDevice bluetoothDevice;
    private final BroadcastReceiver bluetoothHeadsetReceiver;
    private final Runnable bluetoothTimeoutRunnable = new Runnable(){

        @Override
        public void run() {
            AppRTCBluetoothManager.this.bluetoothTimeout();
        }
    };

    static AppRTCBluetoothManager create(Context context, AppRTCAudioManager audioManager) {
        Log.d(TAG, "create" + AppRTCUtils.getThreadInfo());
        return new AppRTCBluetoothManager(context, audioManager);
    }

    protected AppRTCBluetoothManager(Context context, AppRTCAudioManager audioManager) {
        Log.d(TAG, "ctor");
        ThreadUtils.checkIsOnMainThread();
        this.apprtcContext = context;
        this.apprtcAudioManager = audioManager;
        this.audioManager = this.getAudioManager(context);
        this.bluetoothState = State.UNINITIALIZED;
        this.bluetoothServiceListener = new BluetoothServiceListener();
        this.bluetoothHeadsetReceiver = new BluetoothHeadsetBroadcastReceiver();
        this.handler = new Handler(Looper.getMainLooper());
    }

    public State getState() {
        ThreadUtils.checkIsOnMainThread();
        return this.bluetoothState;
    }

    public void start() {
        ThreadUtils.checkIsOnMainThread();
        Log.d(TAG, "start");
        if (!this.hasPermission(this.apprtcContext, "android.permission.BLUETOOTH")) {
            Log.w(TAG, "Process (pid=" + Process.myPid() + ") lacks BLUETOOTH permission");
            return;
        }
        if (this.bluetoothState != State.UNINITIALIZED) {
            Log.w(TAG, "Invalid BT state");
            return;
        }
        this.bluetoothHeadset = null;
        this.bluetoothDevice = null;
        this.scoConnectionAttempts = 0;
        this.bluetoothAdapter = BluetoothAdapter.getDefaultAdapter();
        if (this.bluetoothAdapter == null) {
            Log.w(TAG, "Device does not support Bluetooth");
            return;
        }
        if (!this.audioManager.isBluetoothScoAvailableOffCall()) {
            Log.e(TAG, "Bluetooth SCO audio is not available off call");
            return;
        }
        this.logBluetoothAdapterInfo(this.bluetoothAdapter);
        if (!this.getBluetoothProfileProxy(this.apprtcContext, this.bluetoothServiceListener, 1)) {
            Log.e(TAG, "BluetoothAdapter.getProfileProxy(HEADSET) failed");
            return;
        }
        IntentFilter bluetoothHeadsetFilter = new IntentFilter();
        bluetoothHeadsetFilter.addAction("android.bluetooth.headset.profile.action.CONNECTION_STATE_CHANGED");
        bluetoothHeadsetFilter.addAction("android.bluetooth.headset.profile.action.AUDIO_STATE_CHANGED");
        this.registerReceiver(this.bluetoothHeadsetReceiver, bluetoothHeadsetFilter);
        Log.d(TAG, "HEADSET profile state: " + this.stateToString(this.bluetoothAdapter.getProfileConnectionState(1)));
        Log.d(TAG, "Bluetooth proxy for headset profile has started");
        this.bluetoothState = State.HEADSET_UNAVAILABLE;
        Log.d(TAG, "start done: BT state=" + (Object)((Object)this.bluetoothState));
    }

    public void stop() {
        ThreadUtils.checkIsOnMainThread();
        Log.d(TAG, "stop: BT state=" + (Object)((Object)this.bluetoothState));
        if (this.bluetoothAdapter == null) {
            return;
        }
        this.stopScoAudio();
        if (this.bluetoothState == State.UNINITIALIZED) {
            return;
        }
        this.unregisterReceiver(this.bluetoothHeadsetReceiver);
        this.cancelTimer();
        if (this.bluetoothHeadset != null) {
            this.bluetoothAdapter.closeProfileProxy(1, (BluetoothProfile)this.bluetoothHeadset);
            this.bluetoothHeadset = null;
        }
        this.bluetoothAdapter = null;
        this.bluetoothDevice = null;
        this.bluetoothState = State.UNINITIALIZED;
        Log.d(TAG, "stop done: BT state=" + (Object)((Object)this.bluetoothState));
    }

    public boolean startScoAudio() {
        ThreadUtils.checkIsOnMainThread();
        Log.d(TAG, "startSco: BT state=" + (Object)((Object)this.bluetoothState) + ", attempts: " + this.scoConnectionAttempts + ", SCO is on: " + this.isScoOn());
        if (this.scoConnectionAttempts >= 2) {
            Log.e(TAG, "BT SCO connection fails - no more attempts");
            return false;
        }
        if (this.bluetoothState != State.HEADSET_AVAILABLE) {
            Log.e(TAG, "BT SCO connection fails - no headset available");
            return false;
        }
        Log.d(TAG, "Starting Bluetooth SCO and waits for ACTION_AUDIO_STATE_CHANGED...");
        this.bluetoothState = State.SCO_CONNECTING;
        this.audioManager.startBluetoothSco();
        this.audioManager.setBluetoothScoOn(true);
        ++this.scoConnectionAttempts;
        this.startTimer();
        Log.d(TAG, "startScoAudio done: BT state=" + (Object)((Object)this.bluetoothState) + ", SCO is on: " + this.isScoOn());
        return true;
    }

    public void stopScoAudio() {
        ThreadUtils.checkIsOnMainThread();
        Log.d(TAG, "stopScoAudio: BT state=" + (Object)((Object)this.bluetoothState) + ", SCO is on: " + this.isScoOn());
        if (this.bluetoothState != State.SCO_CONNECTING && this.bluetoothState != State.SCO_CONNECTED) {
            return;
        }
        this.cancelTimer();
        this.audioManager.stopBluetoothSco();
        this.audioManager.setBluetoothScoOn(false);
        this.bluetoothState = State.SCO_DISCONNECTING;
        Log.d(TAG, "stopScoAudio done: BT state=" + (Object)((Object)this.bluetoothState) + ", SCO is on: " + this.isScoOn());
    }

    public void updateDevice() {
        if (this.bluetoothState == State.UNINITIALIZED || this.bluetoothHeadset == null) {
            return;
        }
        Log.d(TAG, "updateDevice");
        List devices = this.bluetoothHeadset.getConnectedDevices();
        if (devices.isEmpty()) {
            this.bluetoothDevice = null;
            this.bluetoothState = State.HEADSET_UNAVAILABLE;
            Log.d(TAG, "No connected bluetooth headset");
        } else {
            this.bluetoothDevice = (BluetoothDevice)devices.get(0);
            this.bluetoothState = State.HEADSET_AVAILABLE;
            Log.d(TAG, "Connected bluetooth headset: name=" + this.bluetoothDevice.getName() + ", state=" + this.stateToString(this.bluetoothHeadset.getConnectionState(this.bluetoothDevice)) + ", SCO audio=" + this.bluetoothHeadset.isAudioConnected(this.bluetoothDevice));
        }
        Log.d(TAG, "updateDevice done: BT state=" + (Object)((Object)this.bluetoothState));
    }

    protected AudioManager getAudioManager(Context context) {
        return (AudioManager)context.getSystemService("audio");
    }

    protected void registerReceiver(BroadcastReceiver receiver, IntentFilter filter) {
        this.apprtcContext.registerReceiver(receiver, filter);
    }

    protected void unregisterReceiver(BroadcastReceiver receiver) {
        this.apprtcContext.unregisterReceiver(receiver);
    }

    protected boolean getBluetoothProfileProxy(Context context, BluetoothProfile.ServiceListener listener, int profile) {
        return this.bluetoothAdapter.getProfileProxy(context, listener, profile);
    }

    protected boolean hasPermission(Context context, String permission2) {
        return this.apprtcContext.checkPermission(permission2, Process.myPid(), Process.myUid()) == 0;
    }

    @SuppressLint(value={"HardwareIds"})
    protected void logBluetoothAdapterInfo(BluetoothAdapter localAdapter) {
        Log.d(TAG, "BluetoothAdapter: enabled=" + localAdapter.isEnabled() + ", state=" + this.stateToString(localAdapter.getState()) + ", name=" + localAdapter.getName() + ", address=" + localAdapter.getAddress());
        Set pairedDevices = localAdapter.getBondedDevices();
        if (!pairedDevices.isEmpty()) {
            Log.d(TAG, "paired devices:");
            for (BluetoothDevice device : pairedDevices) {
                Log.d(TAG, " name=" + device.getName() + ", address=" + device.getAddress());
            }
        }
    }

    private void updateAudioDeviceState() {
        ThreadUtils.checkIsOnMainThread();
        Log.d(TAG, "updateAudioDeviceState");
        this.apprtcAudioManager.updateAudioDeviceState();
    }

    private void startTimer() {
        ThreadUtils.checkIsOnMainThread();
        Log.d(TAG, "startTimer");
        this.handler.postDelayed(this.bluetoothTimeoutRunnable, 4000L);
    }

    private void cancelTimer() {
        ThreadUtils.checkIsOnMainThread();
        Log.d(TAG, "cancelTimer");
        this.handler.removeCallbacks(this.bluetoothTimeoutRunnable);
    }

    private void bluetoothTimeout() {
        ThreadUtils.checkIsOnMainThread();
        if (this.bluetoothState == State.UNINITIALIZED || this.bluetoothHeadset == null) {
            return;
        }
        Log.d(TAG, "bluetoothTimeout: BT state=" + (Object)((Object)this.bluetoothState) + ", attempts: " + this.scoConnectionAttempts + ", SCO is on: " + this.isScoOn());
        if (this.bluetoothState != State.SCO_CONNECTING) {
            return;
        }
        boolean scoConnected = false;
        List devices = this.bluetoothHeadset.getConnectedDevices();
        if (devices.size() > 0) {
            this.bluetoothDevice = (BluetoothDevice)devices.get(0);
            if (this.bluetoothHeadset.isAudioConnected(this.bluetoothDevice)) {
                Log.d(TAG, "SCO connected with " + this.bluetoothDevice.getName());
                scoConnected = true;
            } else {
                Log.d(TAG, "SCO is not connected with " + this.bluetoothDevice.getName());
            }
        }
        if (scoConnected) {
            this.bluetoothState = State.SCO_CONNECTED;
            this.scoConnectionAttempts = 0;
        } else {
            Log.w(TAG, "BT failed to connect after timeout");
            this.stopScoAudio();
        }
        this.updateAudioDeviceState();
        Log.d(TAG, "bluetoothTimeout done: BT state=" + (Object)((Object)this.bluetoothState));
    }

    private boolean isScoOn() {
        return this.audioManager.isBluetoothScoOn();
    }

    private String stateToString(int state) {
        switch (state) {
            case 0: {
                return "DISCONNECTED";
            }
            case 2: {
                return "CONNECTED";
            }
            case 1: {
                return "CONNECTING";
            }
            case 3: {
                return "DISCONNECTING";
            }
            case 10: {
                return "OFF";
            }
            case 12: {
                return "ON";
            }
            case 13: {
                return "TURNING_OFF";
            }
            case 11: {
                return "TURNING_ON";
            }
        }
        return "INVALID";
    }

    private class BluetoothHeadsetBroadcastReceiver
    extends BroadcastReceiver {
        private BluetoothHeadsetBroadcastReceiver() {
        }

        public void onReceive(Context context, Intent intent) {
            if (AppRTCBluetoothManager.this.bluetoothState == State.UNINITIALIZED) {
                return;
            }
            String action = intent.getAction();
            if (action.equals("android.bluetooth.headset.profile.action.CONNECTION_STATE_CHANGED")) {
                int state = intent.getIntExtra("android.bluetooth.profile.extra.STATE", 0);
                Log.d(AppRTCBluetoothManager.TAG, "BluetoothHeadsetBroadcastReceiver.onReceive: a=ACTION_CONNECTION_STATE_CHANGED, s=" + AppRTCBluetoothManager.this.stateToString(state) + ", sb=" + this.isInitialStickyBroadcast() + ", BT state: " + (Object)((Object)AppRTCBluetoothManager.this.bluetoothState));
                if (state == 2) {
                    AppRTCBluetoothManager.this.scoConnectionAttempts = 0;
                    AppRTCBluetoothManager.this.updateAudioDeviceState();
                } else if (state != 1 && state != 3 && state == 0) {
                    AppRTCBluetoothManager.this.stopScoAudio();
                    AppRTCBluetoothManager.this.updateAudioDeviceState();
                }
            } else if (action.equals("android.bluetooth.headset.profile.action.AUDIO_STATE_CHANGED")) {
                int state = intent.getIntExtra("android.bluetooth.profile.extra.STATE", 10);
                Log.d(AppRTCBluetoothManager.TAG, "BluetoothHeadsetBroadcastReceiver.onReceive: a=ACTION_AUDIO_STATE_CHANGED, s=" + AppRTCBluetoothManager.this.stateToString(state) + ", sb=" + this.isInitialStickyBroadcast() + ", BT state: " + (Object)((Object)AppRTCBluetoothManager.this.bluetoothState));
                if (state == 12) {
                    AppRTCBluetoothManager.this.cancelTimer();
                    if (AppRTCBluetoothManager.this.bluetoothState == State.SCO_CONNECTING) {
                        Log.d(AppRTCBluetoothManager.TAG, "+++ Bluetooth audio SCO is now connected");
                        AppRTCBluetoothManager.this.bluetoothState = State.SCO_CONNECTED;
                        AppRTCBluetoothManager.this.scoConnectionAttempts = 0;
                        AppRTCBluetoothManager.this.updateAudioDeviceState();
                    } else {
                        Log.w(AppRTCBluetoothManager.TAG, "Unexpected state BluetoothHeadset.STATE_AUDIO_CONNECTED");
                    }
                } else if (state == 11) {
                    Log.d(AppRTCBluetoothManager.TAG, "+++ Bluetooth audio SCO is now connecting...");
                } else if (state == 10) {
                    Log.d(AppRTCBluetoothManager.TAG, "+++ Bluetooth audio SCO is now disconnected");
                    if (this.isInitialStickyBroadcast()) {
                        Log.d(AppRTCBluetoothManager.TAG, "Ignore STATE_AUDIO_DISCONNECTED initial sticky broadcast.");
                        return;
                    }
                    AppRTCBluetoothManager.this.updateAudioDeviceState();
                }
            }
            Log.d(AppRTCBluetoothManager.TAG, "onReceive done: BT state=" + (Object)((Object)AppRTCBluetoothManager.this.bluetoothState));
        }
    }

    private class BluetoothServiceListener
    implements BluetoothProfile.ServiceListener {
        private BluetoothServiceListener() {
        }

        public void onServiceConnected(int profile, BluetoothProfile proxy) {
            if (profile != 1 || AppRTCBluetoothManager.this.bluetoothState == State.UNINITIALIZED) {
                return;
            }
            Log.d(AppRTCBluetoothManager.TAG, "BluetoothServiceListener.onServiceConnected: BT state=" + (Object)((Object)AppRTCBluetoothManager.this.bluetoothState));
            AppRTCBluetoothManager.this.bluetoothHeadset = (BluetoothHeadset)proxy;
            AppRTCBluetoothManager.this.updateAudioDeviceState();
            Log.d(AppRTCBluetoothManager.TAG, "onServiceConnected done: BT state=" + (Object)((Object)AppRTCBluetoothManager.this.bluetoothState));
        }

        public void onServiceDisconnected(int profile) {
            if (profile != 1 || AppRTCBluetoothManager.this.bluetoothState == State.UNINITIALIZED) {
                return;
            }
            Log.d(AppRTCBluetoothManager.TAG, "BluetoothServiceListener.onServiceDisconnected: BT state=" + (Object)((Object)AppRTCBluetoothManager.this.bluetoothState));
            AppRTCBluetoothManager.this.stopScoAudio();
            AppRTCBluetoothManager.this.bluetoothHeadset = null;
            AppRTCBluetoothManager.this.bluetoothDevice = null;
            AppRTCBluetoothManager.this.bluetoothState = State.HEADSET_UNAVAILABLE;
            AppRTCBluetoothManager.this.updateAudioDeviceState();
            Log.d(AppRTCBluetoothManager.TAG, "onServiceDisconnected done: BT state=" + (Object)((Object)AppRTCBluetoothManager.this.bluetoothState));
        }
    }

    public static enum State {
        UNINITIALIZED,
        ERROR,
        HEADSET_UNAVAILABLE,
        HEADSET_AVAILABLE,
        SCO_DISCONNECTING,
        SCO_CONNECTING,
        SCO_CONNECTED;

    }
}

