/*
 * Decompiled with CFR 0.152.
 */
package com.nexmo.sdk.conversation.client;

import android.os.Parcel;
import android.os.Parcelable;
import org.json.JSONException;
import org.json.JSONObject;

public class User
implements Parcelable {
    private static final String TAG = User.class.getSimpleName();
    private String userId;
    private String name;
    private String displayName;
    private String imageUrl;
    public static final Parcelable.Creator<User> CREATOR = new Parcelable.Creator<User>(){

        public User createFromParcel(Parcel in) {
            return new User(in);
        }

        public User[] newArray(int size) {
            return new User[size];
        }
    };

    private User(String userId, String name, String displayName, String imageUrl) {
        this.userId = userId;
        this.name = name;
        this.displayName = displayName;
        this.imageUrl = imageUrl;
    }

    public User(String userId, String name) {
        this(userId, name, "", "");
    }

    public User(User user) {
        this(user.getUserId(), user.getName(), user.displayName != null ? user.displayName : "", user.imageUrl != null ? user.imageUrl : "");
    }

    protected User(Parcel in) {
        this.userId = in.readString();
        this.name = in.readString();
        this.displayName = in.readString();
        this.imageUrl = in.readString();
    }

    protected User() {
    }

    public static User createUser(String userId, String name, String displayName, String imageUrl) {
        return new User(userId, name, displayName, imageUrl);
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        dest.writeString(this.userId);
        dest.writeString(this.name);
        dest.writeString(this.displayName);
        dest.writeString(this.imageUrl);
    }

    public String getName() {
        return this.name;
    }

    public String getUserId() {
        return this.userId;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public String getImageUrl() {
        return this.imageUrl;
    }

    public String toString() {
        return TAG + " name: " + (this.name != null ? this.name : "") + ". userId: " + (this.userId != null ? this.userId : "") + ". displayName: " + (this.displayName != null ? this.displayName : "") + ". imageUrl: " + (this.imageUrl != null ? this.imageUrl : "");
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        User user = (User)o;
        return this.userId.equals(user.userId) && this.name.equals(user.name) && this.displayName.equals(user.displayName) && this.imageUrl.equals(user.imageUrl);
    }

    public int hashCode() {
        int result = this.userId.hashCode();
        result = 31 * result + (this.name != null ? this.name.hashCode() : 0);
        return result;
    }

    public static User fromJson(JSONObject userObject) throws JSONException {
        return User.createUser(userObject.optString("user_id", userObject.optString("id")), userObject.getString("name"), userObject.optString("display_name"), userObject.optString("image_url"));
    }
}

