/*
 * Decompiled with CFR 0.152.
 */
package com.nexmo.sdk.conversation.client;

import android.os.Parcel;
import android.os.Parcelable;
import android.support.annotation.VisibleForTesting;
import com.nexmo.sdk.conversation.client.Conversation;
import com.nexmo.sdk.conversation.client.DeliveredReceipt;
import com.nexmo.sdk.conversation.client.Event;
import com.nexmo.sdk.conversation.client.Member;
import com.nexmo.sdk.conversation.client.SeenReceipt;
import com.nexmo.sdk.conversation.client.event.EventType;
import com.nexmo.sdk.conversation.core.util.DateUtil;
import java.util.Collection;
import java.util.Date;
import org.json.JSONException;
import org.json.JSONObject;

public class Text
extends Event {
    private static final String TAG = Text.class.getSimpleName();
    private String text;
    public static final Parcelable.Creator<Text> CREATOR = new Parcelable.Creator<Text>(){

        public Text createFromParcel(Parcel in) {
            return new Text(in);
        }

        public Text[] newArray(int size) {
            return new Text[size];
        }
    };

    @VisibleForTesting(otherwise=4)
    protected Text() {
    }

    @VisibleForTesting(otherwise=4)
    protected Text(String text) {
        this.text = text;
    }

    @VisibleForTesting(otherwise=4)
    public Text(String text, Conversation conversation) {
        this(text);
        this.conversation = conversation;
    }

    @VisibleForTesting(otherwise=4)
    protected Text(String text, String id, Date timestamp) {
        this(text);
        this.id = id;
        this.timestamp = timestamp;
    }

    @VisibleForTesting(otherwise=4)
    protected Text(String text, String id, Date timestamp, Member member) {
        this(text, id, timestamp);
        this.member = member;
    }

    @VisibleForTesting(otherwise=4)
    protected Text(String text, String id, Date timestamp, Member member, Conversation conversation) {
        this(text, id, timestamp);
        this.member = member;
        this.conversation = conversation;
    }

    @VisibleForTesting(otherwise=4)
    protected Text(String text, String id, Date timestamp, Member member, Date deletedTimestamp) {
        this(text, id, timestamp, member);
        this.deletedTimestamp = deletedTimestamp;
    }

    @VisibleForTesting(otherwise=4)
    protected Text(String text, String id, Date timestamp, Member member, Date deletedTimestamp, Conversation conversation) {
        this(text, id, timestamp, member, deletedTimestamp);
        this.conversation = conversation;
    }

    @VisibleForTesting(otherwise=4)
    protected Text(String text, String id, Date timestamp, Member member, Date deletedTimestamp, Collection<SeenReceipt> seenReceiptList, Collection<DeliveredReceipt> deliveredReceiptList) {
        this(text, id, timestamp, member, deletedTimestamp);
        this.setSeenReceipts(seenReceiptList);
        this.setDeliveryReceipts(deliveredReceiptList);
    }

    @VisibleForTesting(otherwise=4)
    protected Text(String text, String id, Date timestamp, Member member, Conversation conversation, Date deletedTimestamp, Collection<SeenReceipt> seenReceiptList, Collection<DeliveredReceipt> deliveredReceiptList) {
        this(text, id, timestamp, member, deletedTimestamp, seenReceiptList, deliveredReceiptList);
        this.conversation = conversation;
    }

    @VisibleForTesting(otherwise=4)
    protected Text(Text message) {
        this(message.getText(), message.getId(), message.getTimestamp(), message.getMember(), message.getConversation(), message.getDeletedTimestamp(), message.seenReceiptList, message.deliveredReceipts);
    }

    @VisibleForTesting(otherwise=4)
    protected Text(Parcel in) {
        super(in);
        this.text = in.readString();
    }

    public String getText() {
        return this.text;
    }

    @Override
    public EventType getType() {
        return EventType.TEXT;
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        super.writeToParcel(dest, flags);
        dest.writeString(this.text);
    }

    public String toString() {
        return TAG + " text: " + (this.text != null ? this.text : "") + " .id: " + (this.id != null ? this.id : "") + " .timestamp: " + (this.timestamp != null ? this.timestamp.toString() : "") + " .member: " + (this.member != null ? this.member.toString() : " .deletedTimestamp: " + (this.deletedTimestamp != null ? this.deletedTimestamp : " No deletion."));
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Text)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Text text = (Text)o;
        return this.text != null ? this.text.equals(text.text) : text.text == null;
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.text != null ? this.text.hashCode() : 0);
        return result;
    }

    public static Text fromPush(String senderId, String eventId, JSONObject messageObject) throws JSONException {
        Date timestamp = DateUtil.parseDateFromJson(messageObject, "timestamp");
        JSONObject textPayload = messageObject.optJSONObject("body");
        String payload = textPayload.optString("text");
        return new Text(payload, eventId, timestamp, new Member(senderId));
    }

    void setText(String text) {
        this.text = text;
    }
}

